<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Form;

use Admin\Data\Config;
use Laminas\Form\Form;
use Laminas\I18n\Translator\Translator;
use Shop\Common\ShopCommon;

class UserRechargeForm extends Form
{
    private $translator;
    private $paymentCodeArray;

    public function __construct($paymentList, $name = 'user-recharge-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'post');

        $this->translator       = new Translator();
        $this->paymentCodeArray = ShopCommon::createPaymentCodeArray($paymentList);

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'rechargeNum',
            'attributes' => [
                'id'    => 'rechargeNum'
            ]
        ]);

        $this->add([
            'type'  => 'hidden',
            'name'  => 'payCode',
            'attributes' => [
                'id'    => 'payCode'
            ]
        ]);

        $this->add([
            'type'  => 'csrf',
            'name'  => 'shopCsrf',
            'options' => [
                'csrf_options' => [
                    'timeout'  => Config::SHOP_POST_TOKEN_TIMEOUT
                ]
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'rechargeNum',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToFloat']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0
                    ]
                ]
            ],
            'error_message' => $this->translator->translate('请输入大于0的金额数值')
        ]);

        $inputFilter->add([
            'name'      => 'payCode',
            'required'  => true,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => $this->paymentCodeArray
                    ]
                ]
            ],
            'error_message' => $this->translator->translate('请选择支付方式')
        ]);

    }
}