<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Form;

use Admin\Data\Common;
use Admin\Data\Config;
use Laminas\Form\Form;
use Laminas\Validator\Hostname;
use Shop\Validator\PhoneCaptchaValidator;
use User\Validator\UserEmailExistsValidator;
use User\Validator\UserExistsValidator;
use User\Validator\UserPhoneExistsValidator;

class UserRegisterForm extends Form
{
    private $phoneArea;
    private $entityManager;
    private $registerEmailState;//判断是否启用电子邮箱注册项
    private $registerPhoneState;//判断是否启用电话号码注册项
    private $phoneCaptchaState;//判断是否启用手机验证码，必须开启上面的电话注册项

    public function __construct(array $phoneArea, $entityManager, $name = 'user-register-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'post');

        $this->phoneArea    = $phoneArea;
        $this->entityManager= $entityManager;

        $this->registerEmailState = Common::configValue('register_email_state', 'customer');
        $this->registerPhoneState = Common::configValue('register_phone_state', 'customer');
        $this->phoneCaptchaState  = Common::configValue('register_phone_captcha', 'customer');

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'userName',
            'attributes'=> [
                'id'    => 'userName'
            ]
        ]);

        if ($this->registerEmailState == 1) {
            $this->add([
                'type'  => 'email',
                'name'  => 'userEmail',
                'attributes'=> [
                    'id'    => 'userEmail'
                ]
            ]);
        }

        if ($this->registerPhoneState == 1) {
            if(count($this->phoneArea) == 1) {
                $this->add([
                    'type'  => 'hidden',
                    'name'  => 'areaCode',
                    'attributes'=> [
                        'id'    => 'areaCode',
                        'value' => $this->phoneArea[0]['areaCode']
                    ]
                ]);
            } else {
                $this->add([
                    'type'  => 'select',
                    'name'  => 'areaCode',
                    'attributes'=> [
                        'id'    => 'areaCode',
                        'value' => $this->phoneArea['default']
                    ],
                    'options' => [
                        'value_options' => $this->phoneArea['list']
                    ]
                ]);
            }

            $this->add([
                'type'  => 'text',
                'name'  => 'userPhone',
                'attributes'=> [
                    'id'    => 'userPhone'
                ]
            ]);

            if ($this->phoneCaptchaState == 1) {
                $this->add([
                    'type'  => 'text',
                    'name'  => 'phoneCaptcha',
                    'attributes'=> [
                        'id'    => 'phoneCaptcha'
                    ]
                ]);
            }
        }

        $this->add([
            'type'  => 'password',
            'name'  => 'userPassword',
            'attributes'=> [
                'id'    => 'userPassword'
            ]
        ]);

        $this->add([
            'type'  => 'password',
            'name'  => 'userComPassword',
            'attributes'    => [
                'id'            => 'userComPassword'
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'agreement',
            'attributes'    => [
                'id' => 'agreement'
            ]
        ]);

        $this->add([
            'type'  => 'hidden',
            'name'  => 'httpReferer',
            'attributes' => [
                'id'    => 'httpReferer'
            ]
        ]);

        if(Common::configValue('captcha', 'config')['user_register_captcha'] == 1) {
            $this->add([
                'type'  => 'captcha',
                'name' => 'userRegisterCaptcha',
                'attributes'    => [
                    'id'            => 'userRegisterCaptcha'
                ],
                'options' => [
                    'captcha' => [
                        'class' => 'Figlet',
                        'wordLen' => 4,
                        'expiration' => 180
                    ],
                ],
            ]);
        }

        $this->add([
            'type'  => 'csrf',
            'name'  => 'shopCsrf',
            'options' => [
                'csrf_options' => [
                    'timeout'  => Config::SHOP_POST_TOKEN_TIMEOUT
                ]
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'userName',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 100
                    ]
                ],
                [
                    'name'      => UserExistsValidator::class,
                    'options'    => [
                        'entityManager' => $this->entityManager,
                        'userInfo'      => null
                    ]
                ]
            ]
        ]);

        if ($this->registerEmailState == 1) {
            $inputFilter->add([
                'name'      => 'userEmail',
                'required'  => true,
                'filters'   => [
                    ['name' => 'StringTrim']
                ],
                'validators'=> [
                    [
                        'name'      => 'StringLength',
                        'options'   => [
                            'min'   => 1,
                            'max'   => 100
                        ]
                    ],
                    /*[
                        'name'      => 'EmailAddress',
                        'options'   => [
                            'allow'         => Hostname::ALLOW_DNS,
                            'useMxCheck'    => false
                        ]
                    ],*/
                    [
                        'name'      => UserEmailExistsValidator::class,
                        'options'    => [
                            'entityManager' => $this->entityManager,
                            'userInfo'      => null
                        ]
                    ]
                ]
            ]);
        }

        if ($this->registerPhoneState == 1) {
            $inputFilter->add([
                'name'      => 'userPhone',
                'required'  => true,
                'filters'   => [
                    ['name' => 'StringTrim'],
                    ['name' => 'StripTags'],
                    ['name' => 'HtmlEntities']
                ],
                'validators'=> [
                    [
                        'name' => UserPhoneExistsValidator::class,
                        'options'   => [
                            'entityManager' => $this->entityManager,
                            'userInfo'      => null
                        ]
                    ],
                    [
                        'name'      => 'StringLength',
                        'options'   => [
                            'min'   => 1,
                            'max'   => 30
                        ]
                    ]
                ]
            ]);

            if ($this->phoneCaptchaState == 1) {
                $inputFilter->add([
                    'name'      => 'phoneCaptcha',
                    'required'  => true,
                    'filters'   => [
                        ['name' => 'ToInt']
                    ],
                    'validators'=> [
                        [
                            'name' => PhoneCaptchaValidator::class
                        ]
                    ]
                ]);
            }
        }

        $inputFilter->add([
            'name'      => 'userPassword',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 6
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'userComPassword',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim']
            ],
            'validators'=> [
                [
                    'name'      => 'Identical',
                    'options'   => [
                        'token' => 'userPassword'
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'agreement',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'httpReferer',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim']
            ]
        ]);
    }
}