<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop;

use Admin\Data\Common;
use Laminas\Config\Factory;
use Laminas\ModuleManager\ModuleEvent;
use Laminas\ModuleManager\ModuleManager;
use Laminas\Mvc\MvcEvent;
use Laminas\Validator\AbstractValidator;
use Shop\Service\ShopUserManager;

class Module
{
    public function init(ModuleManager $moduleManager)
    {
        //$events = $moduleManager->getEventManager();
        //$events->attach(ModuleEvent::EVENT_LOAD_MODULE_RESOLVE, [$this, 'onShopMergeConfig'], 100);
    }

    public function getConfig()
    {
        return include __DIR__ . '/../config/module.config.php';
    }

    public function onBootstrap(MvcEvent $event)
    {
        $eventManager = $event->getApplication()->getEventManager();

        $eventManager->attach(MvcEvent::EVENT_DISPATCH, [$this, 'checkUserAccount'], 200);
        $eventManager->attach(MvcEvent::EVENT_DISPATCH, [$this, 'shopLayout'], 100);
    }

    public function onShopMergeConfig(ModuleEvent $event)
    {
        $configListener = $event->getConfigListener();
        $config         = $configListener->getMergedConfig(false);
        if (!empty($config)) {
            $configListener->setMergedConfig($config);
        }
    }

    /**
     * 设置模板调用
     * @param MvcEvent $event
     * @return \Laminas\View\Model\ModelInterface
     */
    public function shopLayout(MvcEvent $event)
    {
        $controllerName = $event->getRouteMatch()->getParam('controller', null);
        if(
            substr($controllerName, 0, strpos($controllerName, '\\')) == __NAMESPACE__
            || strpos($controllerName, 'Controller\ShopPlugin') !== false
        ) {
            $viewModel = $event->getViewModel();

            $shopConfig = Common::readConfigFile('config');
            //关闭前台
            if($shopConfig['base']['website_close'] == 1) {
                $viewModel->setTemplate('shop/close');
                return $viewModel->setVariables([]);
            }

            //前台语言包
            if (isset($shopConfig['base']['f_language']) && !empty($shopConfig['base']['f_language']) && $shopConfig['base']['f_language'] != 'zh_CN') {
                $serviceManager = $event->getApplication()->getServiceManager();
                $translator     = $serviceManager->get('MvcTranslator');
                $translator->setLocale($shopConfig['base']['f_language']);
                //服务器端验证进行语言设置
                AbstractValidator::setDefaultTranslator($translator);
            }

            $viewModel->setVariable('versionNumber', DBSHOP_VERSION_NUMBER);
            $viewModel->setTemplate('shop/layout');
        }
    }

    /**
     * 检查客户状态
     * @param MvcEvent $event
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    public function checkUserAccount(MvcEvent $event)
    {
        $controllerName = $event->getRouteMatch()->getParam('controller', null);
        if(
            substr($controllerName, 0, strpos($controllerName, '\\')) == __NAMESPACE__
            || substr(basename($controllerName), 0, 10) == 'ShopPlugin' //检查是否为插件的前台
        ) {
            $sm = $event->getApplication()->getServiceManager();
            if ($sm->get('ControllerPluginManager')->get('shopPlugin')->checkUserLoginStatus()) {
                $sm->get(ShopUserManager::class)->checkUser();
            }
        }
    }
}