<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Plugin;

use Admin\Data\Common;
use Cms\Entity\Cms;
use Cms\Entity\SingleCms;
use Doctrine\ORM\EntityManager;
use Goods\Entity\GoodsClass;
use Goods\Entity\GoodsSpecTagGoods;
use Laminas\Mvc\Controller\Plugin\AbstractPlugin;
use Laminas\Mvc\I18n\Translator;
use Operation\Entity\Ad;
use Operation\Entity\AdSlide;

class ShopPartialPlugin extends AbstractPlugin
{
    private $entityManager;
    private $translator;

    public function __construct(
        EntityManager   $entityManager,
        Translator      $translator
    )
    {
        $this->entityManager    = $entityManager;
        $this->translator       = $translator;
    }

    /**
     * 前台首页新闻
     * @param $newsNum
     * @param $templateCode
     * @return array
     */
    public function shopIndexNews($newsNum, $templateCode)
    {
        $newsList = $this->entityManager->getRepository(Cms::class)->findShopIndexNews($newsNum);
        $newsArray= [];
        if ($newsList == null) return $newsArray;

        foreach ($newsList as $item) {
            $newsArray[] = [
                'id'    => $item[0]->getCmsId(),
                'title' => $item[0]->getCmsTitle()
            ];
        }

        return $newsArray;
    }

    /**
     * 前台单页文章调用（多个调用）
     * @param $singleTag
     * @param $templateCode
     * @return array
     */
    public function shopMoreSingleCms($singleTag, $templateCode)
    {
        $singleCmsArray = [];
        $singleCmsList  = $this->entityManager->getRepository(SingleCms::class)->findBy(['singleTag' => $singleTag, 'templateCode' => $templateCode], ['singleCmsSort' => 'ASC']);
        if($singleCmsList == null) return $singleCmsArray;

        foreach ($singleCmsList as $item) {
            $singleCmsArray[] = [
                'id'    => $item->getSingleCmsId(),
                'title' => $item->getSingleCmsTitle(),
                'body'  => $item->getSingleCmsBody()
            ];
        }

        return $singleCmsArray;
    }

    /**
     * 前台单页文章调用（单个调用）
     * @param $singleTag
     * @param $templateCode
     * @return array
     */
    public function shopSingleCms($singleTag, $templateCode)
    {
        $singleCmsInfo = $this->entityManager->getRepository(SingleCms::class)->findOneBy(['singleTag' => $singleTag, 'templateCode' => $templateCode]);
        if($singleCmsInfo == null) return [];

        return [
            'id'    => $singleCmsInfo->getSingleCmsId(),
            'title' => $singleCmsInfo->getSingleCmsTitle(),
            'body'  => $singleCmsInfo->getSingleCmsBody()
        ];
    }

    /**
     * 前台广告显示
     * @param $adCode
     * @param $templateCode
     * @return mixed
     */
    public function shopAdShow($adCode, $templateCode)
    {
        $adArray= [];
        $adInfo = $this->entityManager->getRepository(Ad::class)->findOneBy(['adPlaceCode' => $adCode, 'templateCode' => $templateCode, 'adState' => 1]);
        if($adInfo == null) return $adArray;
        if((!empty($adInfo->getAdStartTime()) && $adInfo->getAdStartTime() < time()) || (!empty($adInfo->getAdEndTime()) && $adInfo->getAdEndTime() > time())) return $adArray;

        if($adInfo->getAdType() == 'image') {
            $adArray = [
                'ad_url'    => $adInfo->getAdUrl(),
                'ad_image'  => $adInfo->getAdBody()
            ];
        } else {
            $slideImage = $this->entityManager->getRepository(AdSlide::class)->findBy(['adId' => $adInfo->getAdId()], ['adSlideSort' => 'ASC']);
            if($slideImage) foreach ($slideImage as $imageValue) {
                $adArray[] = [
                    'ad_url'    => $imageValue->getAdSlideUrl(),
                    'ad_image'  => $imageValue->getAdSlideImage()
                ];
            }
        }

        return $adArray;
    }

    /**
     * 前台商品显示
     * @param $goodsTag
     * @param $templateCode
     * @return mixed
     */
    public function shopGoodsShow($goodsTag, $templateCode)
    {
        $goodsList = $this->entityManager->getRepository(GoodsSpecTagGoods::class)->findSpecTagGoodsByTagAndTemplate($goodsTag, $templateCode, $this->getController()->shopPlugin()->getUserLoginData('user_group_id'));

        return $goodsList;
    }

    /**
     * 获取两级的商品分类
     * @return array
     */
    public function secGoodsClass()
    {
        //商品分类
        $goodsClass = $this->entityManager->getRepository(GoodsClass::class)->findBy(['classState' => 1], ['classTopId' => 'ASC', 'classSort' => 'ASC']);
        $classList  = Common::classOptions($goodsClass, 0, 'getClassTopId', 'getClassId', 2);

        $classArray     = [];
        $subClassArray  = [];
        if($classList) foreach ($classList as $classValue) {
            if($classValue->getClassTopId() == 0) $classArray[] = $classValue;
            else $subClassArray[$classValue->getClassTopId()][] = $classValue;
        }

        return ['classArray' => $classArray, 'subClassArray' => $subClassArray];
    }
}