<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Validator;

use Admin\Data\Common;
use Laminas\Validator\AbstractValidator;

class BalancePayPasswordValidator extends AbstractValidator
{
    const NOT_SCALAR        = 'notScalar';
    const PAY_PASSWORD_ERROR= 'payPasswordError';

    protected $messageTemplates = [
        self::NOT_SCALAR        => '这不是一个标准输入值',
        self::PAY_PASSWORD_ERROR=> '支付密码错误'
    ];

    protected $userInfo;

    public function __construct($options = null)
    {
        if(isset($options['userInfo']))    $this->userInfo = $options['userInfo'];

        parent::__construct($options);
    }

    public function isValid($value)
    {
        if (!is_scalar($value)) {
            $this->error(self::NOT_SCALAR);
            return false;
        }

        $isValid = true;
        if(!Common::verifyPayPassword($value, $this->userInfo->getPayPassword())) {
            $isValid = false;
            $this->error(self::PAY_PASSWORD_ERROR);
        }

        return $isValid;
    }
}