<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Validator;

use Admin\Data\Common;
use Laminas\Validator\AbstractValidator;

class UserLoginPasswordValidator extends AbstractValidator
{
    const NOT_SCALAR        = 'notScalar';
    const LOGIN_PASSWORD_ERROR= 'loginPasswordError';

    protected $messageTemplates = [
        self::NOT_SCALAR            => '这不是一个标准输入值',
        self::LOGIN_PASSWORD_ERROR  => '登录密码错误'
    ];

    protected $userInfo;

    public function __construct($options = null)
    {
        if(isset($options['userInfo']))    $this->userInfo = $options['userInfo'];

        parent::__construct($options);
    }

    public function isValid($value)
    {
        if (!is_scalar($value)) {
            $this->error(self::NOT_SCALAR);
            return false;
        }

        $isValid = true;
        if(!Common::verifyUserPassword($value, $this->userInfo->getUserPassword())) {
            $isValid = false;
            $this->error(self::LOGIN_PASSWORD_ERROR);
        }

        return $isValid;
    }
}