<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Validator;

use Laminas\Validator\AbstractValidator;
use User\Entity\User;

class UserLoginValidator extends AbstractValidator
{
    const USER_NOT_EXIST= 'userNotExist';
    const USER_CLOSE    = 'userClose';
    const USER_AUDI     = 'userAudi';

    protected $options = [
        'entityManager'
    ];

    protected $messageTemplates = [
        self::USER_NOT_EXIST=> '该账户不存在',
        self::USER_CLOSE    => "您目前的账户处于关闭状态，暂时无法登录",
        self::USER_AUDI     => "您目前的账户处于待审核状态，审核完成后才能登录"
    ];

    public function __construct($options = null)
    {
        if(isset($options['entityManager']))  $this->options['entityManager'] = $options['entityManager'];
        parent::__construct($options);
    }

    public function isValid($value)
    {
        $userInfo = $this->options['entityManager']->getRepository(User::class)->findUserLogin($value);
        if($userInfo == null) {
            $this->error(self::USER_NOT_EXIST);
            return false;
        }

        if($userInfo->getUserStatus() == 2) {
            $this->error(self::USER_CLOSE);
            return false;
        }

        if($userInfo->getUserStatus() == 3) {
            $this->error(self::USER_AUDI);
            return false;
        }

        return true;
    }
}