<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\Validator;

use Laminas\Validator\AbstractValidator;

class UserWithdrawMoneyValidator extends AbstractValidator
{
    const NOT_SCALAR    = 'notScalar';
    const MONEY_MIN     = 'moneyMin';
    const MONEY_MAX     = 'moneyMax';

    protected $messageTemplates = [
        self::NOT_SCALAR    => '这不是一个标准输入值',
        self::MONEY_MIN     => "提现金额太小，请重新输入",
        self::MONEY_MAX     => "提现金额超过账户余额，无法进行提现处理"
    ];

    protected $userInfo;

    public function __construct($options = null)
    {
        if(isset($options['userInfo']))    $this->userInfo = $options['userInfo'];

        parent::__construct($options);
    }

    public function isValid($value)
    {
        if(!is_scalar($value)) {
            $this->error(self::NOT_SCALAR);
            return false;
        }

        if($value <= 0) {
            $this->error(self::MONEY_MIN);
            return false;
        }

        $isValid = true;

        if($value > $this->userInfo->getUserMoney()) {
            $isValid = false;
            $this->error(self::MONEY_MAX);
        }

        return $isValid;
    }
}