<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace Shop\View;

use Admin\Data\Common;
use Admin\Data\Config;
use Laminas\I18n\View\Helper\CurrencyFormat;
use Laminas\Session\Container;

class FrontCurrency extends CurrencyFormat
{
    private $dbshopSession;

    public function __construct()
    {
        if($this->dbshopSession == null) $this->dbshopSession = new Container('dbshopSession');
    }

    public function __invoke(
        $number,
        $pattern = null,
        $currencyCode = null,
        $showDecimals = null,
        $locale = null

    )
    {
        if(
            $this->getView()->shopHelper()->checkUserLoginStatus() == null
            && Common::configValue('goods', 'config')['login_goods_price_show'] == 1
        ) return $this->getView()->translate('登录可见');

        if (null === $locale) {
            $locale = Config::SHOP_CURRENCY_LOCALE;
        }

        $currencyArray = Common::readConfigFile('currency');
        if($this->dbshopSession->offsetGet('currencyCode') && $currencyArray[$this->dbshopSession->offsetGet('currencyCode')]['state'] == 1) {
            $currencyCode = $this->dbshopSession->offsetGet('currencyCode');
            $currencyRate = $currencyArray[$this->dbshopSession->offsetGet('currencyCode')]['rate'];
        } else {
            $currencyCode = $currencyArray['default']['code'];
            $currencyRate = $currencyArray['default']['rate'];
            $this->dbshopSession->offsetSet('currencyCode', $currencyCode);
        }

        $number = $number * $currencyRate;

        if (null === $showDecimals) {
            $showDecimals = 2;
        }
        if (null === $pattern) {
            $pattern = $this->getCurrencyPattern();
        }

        if($number == 0.00) return 0;

        return parent::__invoke($number, $currencyCode, $showDecimals, $locale, $pattern);
    }
}