<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User;

use Admin\Data\Config;
use User\Controller\BalanceController;
use User\Controller\Factory\BalanceControllerFactory;
use User\Controller\Factory\IndexControllerFactory;
use User\Controller\Factory\IntegralControllerFactory;
use User\Controller\Factory\UserGroupControllerFactory;
use User\Controller\IndexController;
use Doctrine\ORM\Mapping\Driver\AnnotationDriver;
use User\Controller\IntegralController;
use User\Controller\UserGroupController;
use User\Entity\UserGoodsFavorites;
use User\Event\Factory\UserListenerFactory;
use User\Event\UserListener;
use User\Plugin\Factory\UserPluginFactory;
use User\Plugin\UserPlugin;
use User\Service\BalanceLogManager;
use User\Service\CartManager;
use User\Service\Factory\BalanceLogManagerFactory;
use User\Service\Factory\CartManagerFactory;
use User\Service\Factory\IntegralLogManagerFactory;
use User\Service\Factory\IntegralRuleManagerFactory;
use User\Service\Factory\IntegralTypeManagerFactory;
use User\Service\Factory\UserAddressManagerFactory;
use User\Service\Factory\UserGoodsFavoritesManagerFactory;
use User\Service\Factory\UserGroupManagerFactory;
use User\Service\Factory\UserIntegralConfirmManagerFactory;
use User\Service\Factory\UserManagerFactory;
use User\Service\Factory\UserOtherLoginManagerFactory;
use User\Service\Factory\UserRechargeManagerFactory;
use User\Service\Factory\UserWithdrawManagerFactory;
use User\Service\IntegralLogManager;
use User\Service\IntegralRuleManager;
use User\Service\IntegralTypeManager;
use User\Service\UserAddressManager;
use User\Service\UserGoodsFavoritesManager;
use User\Service\UserGroupManager;
use User\Service\UserIntegralConfirmManager;
use User\Service\UserManager;
use User\Service\UserOtherLoginManager;
use User\Service\UserRechargeManager;
use User\Service\UserWithdrawManager;
use User\View\Factory\UserHelperFactory;
use User\View\UserHelper;
use Laminas\Router\Http\Segment;

return [
    'router' => [
        'routes' => [
            'user' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/user[/:action[/:id]]',
                    'defaults' => [
                        'controller' => IndexController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'user-group' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/user-group[/:action[/:id]]',
                    'defaults' => [
                        'controller' => UserGroupController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'user-balance' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/user-balance[/:action[/:id]]',
                    'defaults' => [
                        'controller' => BalanceController::class,
                        'action'    => 'index'
                    ]
                ]
            ],

            'user-integral' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/' . Config::ADMIN_PATH . '/user-integral[/:action[/:id]]',
                    'defaults' => [
                        'controller' => IntegralController::class,
                        'action'    => 'index'
                    ]
                ]
            ],
        ]

    ],

    'controllers' => [
        'factories' => [
            IndexController::class      => IndexControllerFactory::class,
            UserGroupController::class  => UserGroupControllerFactory::class,
            BalanceController::class    => BalanceControllerFactory::class,
            IntegralController::class   => IntegralControllerFactory::class
        ]
    ],

    'service_manager' => [
        'factories' => [
            UserManager::class              => UserManagerFactory::class,
            UserGroupManager::class         => UserGroupManagerFactory::class,
            IntegralTypeManager::class      => IntegralTypeManagerFactory::class,
            IntegralRuleManager::class      => IntegralRuleManagerFactory::class,
            IntegralLogManager::class       => IntegralLogManagerFactory::class,
            BalanceLogManager::class        => BalanceLogManagerFactory::class,
            UserGoodsFavoritesManager::class=> UserGoodsFavoritesManagerFactory::class,
            CartManager::class              => CartManagerFactory::class,
            UserAddressManager::class       => UserAddressManagerFactory::class,
            UserRechargeManager::class      => UserRechargeManagerFactory::class,
            UserWithdrawManager::class      => UserWithdrawManagerFactory::class,
            UserIntegralConfirmManager::class => UserIntegralConfirmManagerFactory::class,
            UserOtherLoginManager::class    => UserOtherLoginManagerFactory::class,

            UserListener::class     => UserListenerFactory::class
        ]
    ],

    'listeners' => [
        UserListener::class
    ],

    'permission_filter' => include __DIR__ . '/permission.php',

    'controller_plugins' => [
        'factories' => [
            UserPlugin::class => UserPluginFactory::class
        ],
        'aliases'   => [
            'userPlugin' => UserPlugin::class
        ]
    ],

    'view_helpers' => [
        'factories' => [
            UserHelper::class => UserHelperFactory::class
        ],
        'aliases' => [
            'userHelper' => UserHelper::class
        ],
    ],

    'translator' => [
        'translation_file_patterns' => [
            [
                'type' => 'gettext',
                'base_dir' => __DIR__ . '/../data/language',
                'pattern' => '%s.mo'
            ]
        ]
    ],

    'view_manager' => [
        'template_path_stack' => [
            __DIR__ . '/../view',
        ],
        'strategies' => [
            'ViewJsonStrategy',
        ]
    ],

    'doctrine' => [
        'driver' => [
            __NAMESPACE__ . '_driver' => [
                'class' => AnnotationDriver::class,
                'cache' => 'array',
                'paths' => [__DIR__ . '/../src/Entity']
            ],
            'orm_default' => [
                'drivers' => [
                    __NAMESPACE__ . '\Entity' => __NAMESPACE__ . '_driver'
                ]
            ]
        ]
    ]
];