<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User;

use User\Controller\BalanceController;
use User\Controller\IndexController;
use User\Controller\IntegralController;
use User\Controller\UserGroupController;

return [
    'User' => [
        'name' => '客户',
        'controllers' => [
            IndexController::class => [
                'name' => '客户管理',
                'action' => ['index', 'add', 'edit', 'delete', 'deleteMore', 'changeUserPassword', 'changePayPassword'],
                'actionNames' => [
                    'index' => '客户列表',
                    'add'   => '添加客户',
                    'edit'  => '编辑客户',
                    'delete'=> '删除客户',
                    'deleteMore' => '批量删除客户',
                    'changeUserPassword'=> '修改密码',
                    'changePayPassword' => '支付密码修改'
                ]
            ],

            UserGroupController::class => [
                'name' => '客户组管理',
                'action' => ['index', 'add', 'edit', 'delete'],
                'actionNames' => [
                    'index' => '客户组列表',
                    'add'   => '添加客户组',
                    'edit'  => '编辑客户组',
                    'delete'=> '删除客户组'
                ]
            ],

            BalanceController::class => [
                'name' => '余额',
                'action' => [
                    'index', 'editUserBalance',
                    'rechargeList', 'deleteRecharge',
                    'withdrawList', 'reviewWithdraw', 'deleteWithdraw'
                ],
                'actionNames' => [
                    'index'             => '余额记录',
                    'editUserBalance'   => '客户余额调整',
                    'rechargeList'      => '充值列表',
                    'deleteRecharge'    => '删除充值记录',
                    'deleteNoPayRecharge' => '一键删除未充值记录',
                    'withdrawList'      => '提现列表',
                    'reviewWithdraw'    => '审核提现',
                    'deleteWithdraw'    => '删除提现申请'
                ]
            ],

            IntegralController::class => [
                'name' => '积分',
                'action' => [
                    'index', 'editIntegralType',
                    'editUserIntegral',
                    'integralRule', 'addIntegralRule', 'editIntegralRule', 'deleteIntegralRule',
                    'integralLog'
                ],
                'actionNames' => [
                    'index'                 => '积分类型',
                    'editIntegralType'      => '类型编辑',
                    'editUserIntegral'      => '客户积分调整',
                    'integralRule'          => '积分规则',
                    'addIntegralRule'       => '添加积分规则',
                    'editIntegralRule'      => '编辑积分规则',
                    'deleteIntegralRule'    => '删除积分规则',
                    'integralLog'           => '积分记录'
                ]
            ]
        ]
    ]
];