<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Controller\Factory;

use Admin\Data\Config;
use User\Controller\IndexController;
use Interop\Container\ContainerInterface;
use User\Service\UserManager;
use Laminas\Mvc\I18n\Translator;
use Laminas\ServiceManager\Factory\FactoryInterface;

class IndexControllerFactory implements FactoryInterface
{
    public function __invoke(ContainerInterface $container, $requestedName, array $options = null)
    {
        $translator         = $container->get(Translator::class);
        $entityManager      = $container->get(Config::SHOP_DATABASE_MANAGER_WRITE);
        $userManager        = $container->get(UserManager::class);

        return new IndexController($translator, $entityManager, $userManager);
    }
}