<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Controller\Factory;

use Admin\Data\Config;
use Interop\Container\ContainerInterface;
use User\Controller\IntegralController;
use User\Service\IntegralLogManager;
use User\Service\IntegralRuleManager;
use User\Service\IntegralTypeManager;
use User\Service\UserManager;
use Laminas\Mvc\I18n\Translator;
use Laminas\ServiceManager\Factory\FactoryInterface;

class IntegralControllerFactory implements FactoryInterface
{
    public function __invoke(ContainerInterface $container, $requestedName, array $options = null)
    {
        $translator         = $container->get(Translator::class);
        $entityManager      = $container->get(Config::SHOP_DATABASE_MANAGER_WRITE);
        $integralTypeManager= $container->get(IntegralTypeManager::class);
        $integralLogManager = $container->get(IntegralLogManager::class);
        $userManager        = $container->get(UserManager::class);
        $integralRuleManager= $container->get(IntegralRuleManager::class);

        return new IntegralController(
            $translator, $entityManager,
            $integralTypeManager,
            $integralLogManager,
            $userManager,
            $integralRuleManager
        );
    }
}