<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 余额记录
 * Class BalanceLog
 * @package User\Entity
 * @ORM\Entity(repositoryClass="User\Repository\BalanceLogRepository")
 * @ORM\Table(name="dbshop_user_balance_log")
 */
class BalanceLog extends BaseEntity
{
    /**
     * 余额记录id（自增）
     * @ORM\Column(name="balance_log_id", type="integer", length=11)
     * @ORM\Id()
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $balanceLogId;

    /**
     * 客户id
     * @ORM\Column(name="user_id", type="integer", length=11)
     */
    private $userId;

    /**
     * 客户名称
     * @ORM\Column(name="user_name", type="string", length=100)
     */
    private $userName;

    /**
     * 余额变动类型，如 充值，消费，购物
     * @ORM\Column(name="balance_change_type", type="integer", length=4)
     */
    private $balanceChangeType;

    /**
     * 余额变动金额
     * @ORM\Column(name="balance_change_num", type="decimal", scale=2)
     */
    private $balanceChangeNum;

    /**
     * 余额变动后，客户余额
     * @ORM\Column(name="balance_changed_amount", type="decimal", scale=2)
     */
    private $balanceChangedAmount;

    /**
     * 余额变动时间
     * @ORM\Column(name="balance_change_time", type="integer", length=10)
     */
    private $balanceChangeTime;

    /**
     * 余额变动备注
     * @ORM\Column(name="balance_change_info", type="string", length=500)
     */
    private $balanceChangeInfo;

    /**
     * 管理员id
     * @ORM\Column(name="admin_id", type="integer", length=11)
     */
    private $adminId = 0;

    /**
     * 管理员名称
     * @var string
     * @ORM\Column(name="admin_name", type="string", length=100)
     */
    private $adminName = '';

    /**
     * @return mixed
     */
    public function getBalanceLogId()
    {
        return $this->balanceLogId;
    }

    /**
     * @param mixed $balanceLogId
     */
    public function setBalanceLogId($balanceLogId): void
    {
        $this->balanceLogId = $balanceLogId;
    }

    /**
     * @return mixed
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * @param mixed $userId
     */
    public function setUserId($userId): void
    {
        $this->userId = $userId;
    }

    /**
     * @return mixed
     */
    public function getUserName()
    {
        return $this->userName;
    }

    /**
     * @param mixed $userName
     */
    public function setUserName($userName): void
    {
        $this->userName = $userName;
    }

    /**
     * @return mixed
     */
    public function getBalanceChangeType()
    {
        return $this->balanceChangeType;
    }

    /**
     * @param mixed $balanceChangeType
     */
    public function setBalanceChangeType($balanceChangeType): void
    {
        $this->balanceChangeType = $balanceChangeType;
    }

    /**
     * @return mixed
     */
    public function getBalanceChangeNum()
    {
        return $this->balanceChangeNum;
    }

    /**
     * @param mixed $balanceChangeNum
     */
    public function setBalanceChangeNum($balanceChangeNum): void
    {
        $this->balanceChangeNum = $balanceChangeNum;
    }

    /**
     * @return mixed
     */
    public function getBalanceChangedAmount()
    {
        return $this->balanceChangedAmount;
    }

    /**
     * @param mixed $balanceChangedAmount
     */
    public function setBalanceChangedAmount($balanceChangedAmount): void
    {
        $this->balanceChangedAmount = $balanceChangedAmount;
    }

    /**
     * @return mixed
     */
    public function getBalanceChangeTime()
    {
        return $this->balanceChangeTime;
    }

    /**
     * @param mixed $balanceChangeTime
     */
    public function setBalanceChangeTime($balanceChangeTime): void
    {
        $this->balanceChangeTime = $balanceChangeTime;
    }

    /**
     * @return mixed
     */
    public function getBalanceChangeInfo()
    {
        return $this->balanceChangeInfo;
    }

    /**
     * @param mixed $balanceChangeInfo
     */
    public function setBalanceChangeInfo($balanceChangeInfo): void
    {
        $this->balanceChangeInfo = $balanceChangeInfo;
    }

    /**
     * @return mixed
     */
    public function getAdminId()
    {
        return $this->adminId;
    }

    /**
     * @param mixed $adminId
     */
    public function setAdminId($adminId): void
    {
        $this->adminId = $adminId;
    }

    /**
     * @return string
     */
    public function getAdminName()
    {
        return $this->adminName;
    }

    /**
     * @param string $adminName
     */
    public function setAdminName(string $adminName): void
    {
        $this->adminName = $adminName;
    }
}