<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 购物车
 * Class Cart
 * @package User\Entity
 * @ORM\Entity(repositoryClass="User\Repository\CartRepository")
 * @ORM\Table(name="dbshop_cart")
 */
class Cart extends BaseEntity
{
    /**
     * 购物车自增id
     * @ORM\Id()
     * @ORM\Column(name="cart_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $cartId;

    /**
     * 会员id
     * @ORM\Column(name="user_id", type="integer", length=11)
     */
    private $userId;

    /**
     * 商品id
     * @ORM\Column(name="goods_id", type="integer", length=11)
     */
    private $goodsId;

    /**
     * 商品规格id
     * @ORM\Column(name="in_spec_goods_id", type="integer", length=11)
     */
    private $inSpecGoodsId;

    /**
     * 商品批发对应的id
     * @ORM\Column(name="in_wholesale_id", type="integer", length=11)
     */
    private $inWholesaleId;

    /**
     * 商品购买数量
     * @ORM\Column(name="buy_num", type="integer", length=11)
     */
    private $buyNum;

    /**
     * 商品购物车中是否选中，1 选中，2 未选中
     * @ORM\Column(name="goods_checked", type="integer", length=1)
     */
    private $goodsChecked = 1;

    /**
     * 是否为直接购买，1 直接购买，0 非直接购买
     * @ORM\Column(name="buy_now", type="integer", length=1)
     */
    private $buyNow;

    /**
     * 商品备注
     * @ORM\Column(name="goods_remark", type="string", length=500)
     */
    private $goodsRemark;

    /**
     * 添加时间
     * @ORM\Column(name="add_time", type="integer", length=10)
     */
    private $addTime;

    /**
     * 更新时间
     * @ORM\Column(name="update_time", type="integer", length=10)
     */
    private $updateTime;

    /**
     * @return mixed
     */
    public function getCartId()
    {
        return $this->cartId;
    }

    /**
     * @param mixed $cartId
     */
    public function setCartId($cartId): void
    {
        $this->cartId = $cartId;
    }

    /**
     * @return mixed
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * @param mixed $userId
     */
    public function setUserId($userId): void
    {
        $this->userId = $userId;
    }

    /**
     * @return mixed
     */
    public function getGoodsId()
    {
        return $this->goodsId;
    }

    /**
     * @param mixed $goodsId
     */
    public function setGoodsId($goodsId): void
    {
        $this->goodsId = $goodsId;
    }

    /**
     * @return mixed
     */
    public function getInSpecGoodsId()
    {
        return $this->inSpecGoodsId;
    }

    /**
     * @param mixed $inSpecGoodsId
     */
    public function setInSpecGoodsId($inSpecGoodsId): void
    {
        $this->inSpecGoodsId = $inSpecGoodsId;
    }

    /**
     * @return mixed
     */
    public function getInWholesaleId()
    {
        return $this->inWholesaleId;
    }

    /**
     * @param mixed $inWholesaleId
     */
    public function setInWholesaleId($inWholesaleId): void
    {
        $this->inWholesaleId = $inWholesaleId;
    }

    /**
     * @return mixed
     */
    public function getBuyNum()
    {
        return $this->buyNum;
    }

    /**
     * @param mixed $buyNum
     */
    public function setBuyNum($buyNum): void
    {
        $this->buyNum = $buyNum;
    }

    /**
     * @return int
     */
    public function getGoodsChecked(): int
    {
        return $this->goodsChecked;
    }

    /**
     * @param int $goodsChecked
     */
    public function setGoodsChecked(int $goodsChecked): void
    {
        $this->goodsChecked = $goodsChecked;
    }

    /**
     * @return mixed
     */
    public function getBuyNow()
    {
        return $this->buyNow;
    }

    /**
     * @param mixed $buyNow
     */
    public function setBuyNow($buyNow): void
    {
        $this->buyNow = $buyNow;
    }

    /**
     * @return mixed
     */
    public function getGoodsRemark()
    {
        return $this->goodsRemark;
    }

    /**
     * @param mixed $goodsRemark
     */
    public function setGoodsRemark($goodsRemark): void
    {
        $this->goodsRemark = $goodsRemark;
    }

    /**
     * @return mixed
     */
    public function getAddTime()
    {
        return $this->addTime;
    }

    /**
     * @param mixed $addTime
     */
    public function setAddTime($addTime): void
    {
        $this->addTime = $addTime;
    }

    /**
     * @return mixed
     */
    public function getUpdateTime()
    {
        return $this->updateTime;
    }

    /**
     * @param mixed $updateTime
     */
    public function setUpdateTime($updateTime): void
    {
        $this->updateTime = $updateTime;
    }
}