<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 积分历史记录表
 * Class IntegralLog
 * @package User\Entity
 * @ORM\Entity(repositoryClass="User\Repository\IntegralLogRepository")
 * @ORM\Table(name="dbshop_integral_log")
 */
class IntegralLog extends BaseEntity
{
    /**
     * 记录自增id
     * @ORM\Id()
     * @ORM\Column(name="integral_log_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $integralLogId;

    /**
     * 客户id
     * @ORM\Column(name="user_id", type="integer", length=11)
     */
    private $userId;

    /**
     * 客户名称
     * @ORM\Column(name="user_name", type="string", length=100)
     */
    private $userName;

    /**
     * 备注描述
     * @ORM\Column(name="integral_log_info", type="string", length=500)
     */
    private $integralLogInfo;

    /**
     * 更改的积分数值
     * @ORM\Column(name="change_integral_num", type="integer", length=11)
     */
    private $changeIntegralNum;

    /**
     * 更改后会员的积分数值
     * @ORM\Column(name="integral_num", type="integer", length=11)
     */
    private $integralNum;

    /**
     * 积分类型
     * @ORM\Column(name="integral_type_id", type="integer", length=11)
     */
    private $integralTypeId;

    /**
     * 积分更改时间
     * @ORM\Column(name="integral_log_time", type="integer", length=10)
     */
    private $integralLogTime;

    /**
     * 管理员id，当时管理员操作时才需要，默认是0
     * @ORM\Column(name="admin_id", type="integer", length=11)
     */
    private $adminId = 0;

    /**
     * 管理员名称，当是管理员操作时，才需要
     * @ORM\Column(name="admin_name", type="string", length=100)
     */
    private $adminName = null;

    /**
     * @return mixed
     */
    public function getIntegralLogId()
    {
        return $this->integralLogId;
    }

    /**
     * @param mixed $integralLogId
     */
    public function setIntegralLogId($integralLogId): void
    {
        $this->integralLogId = $integralLogId;
    }

    /**
     * @return mixed
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * @param mixed $userId
     */
    public function setUserId($userId): void
    {
        $this->userId = $userId;
    }

    /**
     * @return mixed
     */
    public function getUserName()
    {
        return $this->userName;
    }

    /**
     * @param mixed $userName
     */
    public function setUserName($userName): void
    {
        $this->userName = $userName;
    }

    /**
     * @return mixed
     */
    public function getIntegralLogInfo()
    {
        return $this->integralLogInfo;
    }

    /**
     * @param mixed $integralLogInfo
     */
    public function setIntegralLogInfo($integralLogInfo): void
    {
        $this->integralLogInfo = $integralLogInfo;
    }

    /**
     * @return mixed
     */
    public function getChangeIntegralNum()
    {
        return $this->changeIntegralNum;
    }

    /**
     * @param mixed $changeIntegralNum
     */
    public function setChangeIntegralNum($changeIntegralNum): void
    {
        $this->changeIntegralNum = $changeIntegralNum;
    }

    /**
     * @return mixed
     */
    public function getIntegralNum()
    {
        return $this->integralNum;
    }

    /**
     * @param mixed $integralNum
     */
    public function setIntegralNum($integralNum): void
    {
        $this->integralNum = $integralNum;
    }

    /**
     * @return mixed
     */
    public function getIntegralTypeId()
    {
        return $this->integralTypeId;
    }

    /**
     * @param mixed $integralTypeId
     */
    public function setIntegralTypeId($integralTypeId): void
    {
        $this->integralTypeId = $integralTypeId;
    }

    /**
     * @return mixed
     */
    public function getIntegralLogTime()
    {
        return $this->integralLogTime;
    }

    /**
     * @param mixed $integralLogTime
     */
    public function setIntegralLogTime($integralLogTime): void
    {
        $this->integralLogTime = $integralLogTime;
    }

    /**
     * @return int
     */
    public function getAdminId(): int
    {
        return $this->adminId;
    }

    /**
     * @param int $adminId
     */
    public function setAdminId(int $adminId): void
    {
        $this->adminId = $adminId;
    }

    /**
     * @return null
     */
    public function getAdminName()
    {
        return $this->adminName;
    }

    /**
     * @param null $adminName
     */
    public function setAdminName($adminName): void
    {
        $this->adminName = $adminName;
    }
}