<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 积分规则
 * Class IntegralRule
 * @package User\Entity
 * @ORM\Entity(repositoryClass="User\Repository\IntegralRuleRepository")
 * @ORM\Table(name="dbshop_integral_rule")
 */
class IntegralRule extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="integral_rule_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $integralRuleId;

    /**
     * 积分规则名称
     * @ORM\Column(name="integral_rule_title", type="string", length=200)
     */
    private $integralRuleTitle;

    /**
     * 积分规则描述
     * @ORM\Column(name="integral_rule_info", type="string", length=500)
     */
    private $integralRuleInfo;

    /**
     * 积分规则开始时间
     * @ORM\Column(name="integral_rule_start_time", type="integer", length=10)
     */
    private $integralRuleStartTime = 0;

    /**
     * 积分规则结束时间
     * @ORM\Column(name="integral_rule_end_time", type="integer", length=10)
     */
    private $integralRuleEndTime = 0;

    /**
     * 积分规则状态，0 禁用，1 启用
     * @ORM\Column(name="integral_rule_state", type="integer", length=1)
     */
    private $integralRuleState;

    /**
     * 规则类型，会员注册、购物
     * @ORM\Column(name="integral_rule_type", type="string", length=50)
     */
    private $integralRuleType;

    /**
     * 规则详情，数组序列化内容
     * @ORM\Column(name="integral_rule_body", type="text")
     */
    private $integralRuleBody;

    /**
     * 积分类型，消费积分、等级积分
     * @ORM\Column(name="integral_type_id", type="integer", length=1)
     */
    private $integralTypeId;

    /**
     * 获取积分数
     * @ORM\Column(name="integral_num", type="integer", length=11)
     */
    private $integralNum;

    /**
     * 规则客户类型
     * @ORM\Column(name="integral_rule_user_type", type="string", length=30)
     */
    private $integralRuleUserType;

    /**
     * 规则客户内容
     * @ORM\Column(name="integral_rule_user_body", type="text")
     */
    private $integralRuleUserBody;

    /**
     * 规则商品类型
     * @ORM\Column(name="integral_rule_goods_type", type="string", length=30)
     */
    private $integralRuleGoodsType;

    /**
     * 规则商品的内容
     * @ORM\Column(name="integral_rule_goods_body", type="text")
     */
    private $integralRuleGoodsBody;

    /**
     * @return mixed
     */
    public function getIntegralRuleId()
    {
        return $this->integralRuleId;
    }

    /**
     * @param mixed $integralRuleId
     */
    public function setIntegralRuleId($integralRuleId): void
    {
        $this->integralRuleId = $integralRuleId;
    }

    /**
     * @return mixed
     */
    public function getIntegralRuleTitle()
    {
        return $this->integralRuleTitle;
    }

    /**
     * @param mixed $integralRuleTitle
     */
    public function setIntegralRuleTitle($integralRuleTitle): void
    {
        $this->integralRuleTitle = $integralRuleTitle;
    }

    /**
     * @return mixed
     */
    public function getIntegralRuleInfo()
    {
        return $this->integralRuleInfo;
    }

    /**
     * @param mixed $integralRuleInfo
     */
    public function setIntegralRuleInfo($integralRuleInfo): void
    {
        $this->integralRuleInfo = $integralRuleInfo;
    }

    /**
     * @return mixed
     */
    public function getIntegralRuleStartTime()
    {
        return $this->integralRuleStartTime;
    }

    /**
     * @param mixed $integralRuleStartTime
     */
    public function setIntegralRuleStartTime($integralRuleStartTime): void
    {
        $this->integralRuleStartTime = $integralRuleStartTime;
    }

    /**
     * @return mixed
     */
    public function getIntegralRuleEndTime()
    {
        return $this->integralRuleEndTime;
    }

    /**
     * @param mixed $integralRuleEndTime
     */
    public function setIntegralRuleEndTime($integralRuleEndTime): void
    {
        $this->integralRuleEndTime = $integralRuleEndTime;
    }

    /**
     * @return mixed
     */
    public function getIntegralRuleState()
    {
        return $this->integralRuleState;
    }

    /**
     * @param mixed $integralRuleState
     */
    public function setIntegralRuleState($integralRuleState): void
    {
        $this->integralRuleState = $integralRuleState;
    }

    /**
     * @return mixed
     */
    public function getIntegralRuleType()
    {
        return $this->integralRuleType;
    }

    /**
     * @param mixed $integralRuleType
     */
    public function setIntegralRuleType($integralRuleType): void
    {
        $this->integralRuleType = $integralRuleType;
    }

    /**
     * @return mixed
     */
    public function getIntegralRuleBody()
    {
        return $this->integralRuleBody;
    }

    /**
     * @param mixed $integralRuleBody
     */
    public function setIntegralRuleBody($integralRuleBody): void
    {
        $this->integralRuleBody = $integralRuleBody;
    }

    /**
     * @return mixed
     */
    public function getIntegralTypeId()
    {
        return $this->integralTypeId;
    }

    /**
     * @param mixed $integralTypeId
     */
    public function setIntegralTypeId($integralTypeId): void
    {
        $this->integralTypeId = $integralTypeId;
    }

    /**
     * @return mixed
     */
    public function getIntegralNum()
    {
        return $this->integralNum;
    }

    /**
     * @param mixed $integralNum
     */
    public function setIntegralNum($integralNum): void
    {
        $this->integralNum = $integralNum;
    }

    /**
     * @return mixed
     */
    public function getIntegralRuleUserType()
    {
        return $this->integralRuleUserType;
    }

    /**
     * @param mixed $integralRuleUserType
     */
    public function setIntegralRuleUserType($integralRuleUserType): void
    {
        $this->integralRuleUserType = $integralRuleUserType;
    }

    /**
     * @return mixed
     */
    public function getIntegralRuleUserBody()
    {
        return $this->integralRuleUserBody;
    }

    /**
     * @param mixed $integralRuleUserBody
     */
    public function setIntegralRuleUserBody($integralRuleUserBody): void
    {
        $this->integralRuleUserBody = $integralRuleUserBody;
    }

    /**
     * @return mixed
     */
    public function getIntegralRuleGoodsType()
    {
        return $this->integralRuleGoodsType;
    }

    /**
     * @param mixed $integralRuleGoodsType
     */
    public function setIntegralRuleGoodsType($integralRuleGoodsType): void
    {
        $this->integralRuleGoodsType = $integralRuleGoodsType;
    }

    /**
     * @return mixed
     */
    public function getIntegralRuleGoodsBody()
    {
        return $this->integralRuleGoodsBody;
    }

    /**
     * @param mixed $integralRuleGoodsBody
     */
    public function setIntegralRuleGoodsBody($integralRuleGoodsBody): void
    {
        $this->integralRuleGoodsBody = $integralRuleGoodsBody;
    }
}