<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 积分类型表
 * Class IntegralType
 * @package User\Entity
 * @ORM\Entity(repositoryClass="User\Repository\IntegralTypeRepository")
 * @ORM\Table(name="dbshop_integral_type")
 */
class IntegralType extends BaseEntity
{
    /**
     * 积分类型id
     * @ORM\Id()
     * @ORM\Column(name="integral_type_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $integralTypeId;

    /**
     * 积分类型名称
     * @ORM\Column(name="integral_type_name", type="string", length=100)
     */
    private $integralTypeName;

    /**
     * 默认起始积分数
     * @ORM\Column(name="integral_default_num", type="integer", length=11)
     */
    private $integralDefaultNum;

    /**
     * 积分类型标记
     * @ORM\Column(name="integral_type_mark", type="string", length=30)
     */
    private $integralTypeMark;

    /**
     * 每100积分可抵现金(基础货币)数
     * @ORM\Column(name="integral_currency_con", type="integer", length=11)
     */
    private $integralCurrencyCon;

    /**
     * @return mixed
     */
    public function getIntegralTypeId()
    {
        return $this->integralTypeId;
    }

    /**
     * @param mixed $integralTypeId
     */
    public function setIntegralTypeId($integralTypeId): void
    {
        $this->integralTypeId = $integralTypeId;
    }

    /**
     * @return mixed
     */
    public function getIntegralTypeName()
    {
        return $this->integralTypeName;
    }

    /**
     * @param mixed $integralTypeName
     */
    public function setIntegralTypeName($integralTypeName): void
    {
        $this->integralTypeName = $integralTypeName;
    }

    /**
     * @return mixed
     */
    public function getIntegralDefaultNum()
    {
        return $this->integralDefaultNum;
    }

    /**
     * @param mixed $integralDefaultNum
     */
    public function setIntegralDefaultNum($integralDefaultNum): void
    {
        $this->integralDefaultNum = $integralDefaultNum;
    }

    /**
     * @return mixed
     */
    public function getIntegralTypeMark()
    {
        return $this->integralTypeMark;
    }

    /**
     * @param mixed $integralTypeMark
     */
    public function setIntegralTypeMark($integralTypeMark): void
    {
        $this->integralTypeMark = $integralTypeMark;
    }

    /**
     * @return mixed
     */
    public function getIntegralCurrencyCon()
    {
        return $this->integralCurrencyCon;
    }

    /**
     * @param mixed $integralCurrencyCon
     */
    public function setIntegralCurrencyCon($integralCurrencyCon): void
    {
        $this->integralCurrencyCon = $integralCurrencyCon;
    }
}