<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Entity;

use Admin\Data\Common;
use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 客户
 * Class User
 * @package User\Entity
 * @ORM\Entity(repositoryClass="User\Repository\UserRepository")
 * @ORM\Table(name="dbshop_user")
 */
class User extends BaseEntity
{
    /**
     * 客户id
     * @ORM\Id()
     * @ORM\Column(name="user_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $userId;

    /**
     * 客户组id
     * @ORM\Column(name="user_group_id", type="integer", length=11)
     */
    private $userGroupId;

    /**
     * 客户名称
     * @ORM\Column(name="user_name", type="string", length=100)
     */
    private $userName;

    /**
     * 头像
     * @ORM\Column(name="user_avatar", type="string", length=100)
     */
    private $userAvatar;

    /**
     * 客户密码
     * @ORM\Column(name="user_password", type="string", length=72)
     */
    private $userPassword;

    /**
     * 余额支付密码
     * @ORM\Column(name="pay_password", type="string", length=72)
     */
    private $payPassword;

    /**
     * 电子邮箱
     * @ORM\Column(name="user_email", type="string", length=50)
     */
    private $userEmail;

    /**
     * 性别，1 男，2 女，3 保密
     * @ORM\Column(name="user_sex", type="integer", length=1)
     */
    private $userSex = 3;

    /**
     * 生日
     * @ORM\Column(name="user_birthday", type="string", length=10)
     */
    private $userBirthday;

    /**
     * 国际电话地区编码
     * @ORM\Column(name="area_code", type="string", length=10)
     */
    private $areaCode;

    /**
     * 手机号码
     * @ORM\Column(name="user_phone", type="string", length=20)
     */
    private $userPhone;

    /**
     * 状态，1 开启，2 关闭，3 待审核
     * @ORM\Column(name="user_status", type="integer", length=1)
     */
    private $userStatus;

    /**
     * 添加时间
     * @ORM\Column(name="user_add_time", type="integer", length=10)
     */
    private $userAddTime;

    /**
     * 客户余额
     * @ORM\Column(name="user_money", type="decimal", scale=2)
     */
    private $userMoney;

    /**
     * 消费积分
     * @ORM\Column(name="integral_type1_num", type="integer", length=11)
     */
    private $integralType1Num;

    /**
     * 等级积分
     * @ORM\Column(name="integral_type2_num", type="integer", length=11)
     */
    private $integralType2Num;

    /**
     * 邮件验证code
     * @ORM\Column(name="user_email_audit_code", type="string", length=50)
     */
    private $userEmailAuditCode;

    /**
     * 找回密码code
     * @ORM\Column(name="user_forgot_password_code", type="string", length=50)
     */
    private $userForgotPasswordCode;

    /**
     * 客户组
     * @ORM\OneToOne(targetEntity="User\Entity\UserGroup")
     * @ORM\JoinColumn(name="user_group_id", referencedColumnName="user_group_id")
     */
    private $oneUserGroup;

    /**
     * @return mixed
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * @param mixed $userId
     */
    public function setUserId($userId): void
    {
        $this->userId = $userId;
    }

    /**
     * @return mixed
     */
    public function getUserGroupId()
    {
        return $this->userGroupId;
    }

    /**
     * @param mixed $userGroupId
     */
    public function setUserGroupId($userGroupId): void
    {
        $this->userGroupId = $userGroupId;
    }

    /**
     * @return mixed
     */
    public function getUserName()
    {
        return $this->userName;
    }

    /**
     * @param mixed $userName
     */
    public function setUserName($userName): void
    {
        $this->userName = $userName;
    }

    /**
     * @return mixed
     */
    public function getUserAvatar()
    {
        return $this->userAvatar;
    }

    /**
     * @param mixed $userAvatar
     */
    public function setUserAvatar($userAvatar): void
    {
        $this->userAvatar = $userAvatar;
    }

    /**
     * @return mixed
     */
    public function getUserPassword()
    {
        return $this->userPassword;
    }

    /**
     * @param mixed $userPassword
     */
    public function setUserPassword($userPassword): void
    {
        $this->userPassword = Common::createUserPassword($userPassword);
    }

    /**
     * @return mixed
     */
    public function getPayPassword()
    {
        return $this->payPassword;
    }

    /**
     * @param mixed $payPassword
     */
    public function setPayPassword($payPassword): void
    {
        $this->payPassword = Common::createPayPassword($payPassword);
    }

    /**
     * @return mixed
     */
    public function getUserEmail()
    {
        return $this->userEmail;
    }

    /**
     * @param mixed $userEmail
     */
    public function setUserEmail($userEmail): void
    {
        $this->userEmail = $userEmail;
    }

    /**
     * @return int
     */
    public function getUserSex(): int
    {
        return $this->userSex;
    }

    /**
     * @param int $userSex
     */
    public function setUserSex(int $userSex): void
    {
        $this->userSex = $userSex;
    }

    /**
     * @return mixed
     */
    public function getUserBirthday()
    {
        return $this->userBirthday;
    }

    /**
     * @param mixed $userBirthday
     */
    public function setUserBirthday($userBirthday): void
    {
        $this->userBirthday = $userBirthday;
    }

    /**
     * @return mixed
     */
    public function getAreaCode()
    {
        return $this->areaCode;
    }

    /**
     * @param mixed $areaCode
     */
    public function setAreaCode($areaCode): void
    {
        $this->areaCode = $areaCode;
    }

    /**
     * @return mixed
     */
    public function getUserPhone()
    {
        return $this->userPhone;
    }

    /**
     * @param mixed $userPhone
     */
    public function setUserPhone($userPhone): void
    {
        $this->userPhone = $userPhone;
    }

    /**
     * @return mixed
     */
    public function getUserStatus()
    {
        return $this->userStatus;
    }

    /**
     * @param mixed $userStatus
     */
    public function setUserStatus($userStatus): void
    {
        $this->userStatus = $userStatus;
    }

    /**
     * @return mixed
     */
    public function getUserAddTime()
    {
        return $this->userAddTime;
    }

    /**
     * @param mixed $userAddTime
     */
    public function setUserAddTime($userAddTime): void
    {
        $this->userAddTime = $userAddTime;
    }

    /**
     * @return mixed
     */
    public function getUserMoney()
    {
        return $this->userMoney;
    }

    /**
     * @param mixed $userMoney
     */
    public function setUserMoney($userMoney): void
    {
        $this->userMoney = $userMoney;
    }

    /**
     * @return mixed
     */
    public function getIntegralType1Num()
    {
        return $this->integralType1Num;
    }

    /**
     * @param mixed $integralType1Num
     */
    public function setIntegralType1Num($integralType1Num): void
    {
        $this->integralType1Num = $integralType1Num;
    }

    /**
     * @return mixed
     */
    public function getIntegralType2Num()
    {
        return $this->integralType2Num;
    }

    /**
     * @param mixed $integralType2Num
     */
    public function setIntegralType2Num($integralType2Num): void
    {
        $this->integralType2Num = $integralType2Num;
    }

    /**
     * @return mixed
     */
    public function getUserEmailAuditCode()
    {
        return $this->userEmailAuditCode;
    }

    /**
     * @param mixed $userEmailAuditCode
     */
    public function setUserEmailAuditCode($userEmailAuditCode): void
    {
        $this->userEmailAuditCode = $userEmailAuditCode;
    }

    /**
     * @return mixed
     */
    public function getUserForgotPasswordCode()
    {
        return $this->userForgotPasswordCode;
    }

    /**
     * @param mixed $userForgotPasswordCode
     */
    public function setUserForgotPasswordCode($userForgotPasswordCode): void
    {
        $this->userForgotPasswordCode = $userForgotPasswordCode;
    }

    /**
     * @return mixed
     */
    public function getOneUserGroup()
    {
        return $this->oneUserGroup;
    }

    /**
     * @param mixed $oneUserGroup
     */
    public function setOneUserGroup($oneUserGroup): void
    {
        $this->oneUserGroup = $oneUserGroup;
    }
}