<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 收货地址
 * Class UserAddress
 * @package User\Entity
 * @ORM\Entity(repositoryClass="User\Repository\UserAddressRepository")
 * @ORM\Table(name="dbshop_user_address")
 */
class UserAddress extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="address_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $addressId;

    /**
     * 收货人姓名
     * @ORM\Column(name="true_name", type="string", length=100)
     */
    private $trueName;

    /**
     * 地区id
     * @ORM\Column(name="region_id", type="integer", length=11)
     */
    private $regionId;

    /**
     * 地区详情
     * @ORM\Column(name="region_value", type="string", length=255)
     */
    private $regionValue;

    /**
     * 详细地址
     * @ORM\Column(name="address_info", type="string", length=500)
     */
    private $addressInfo;

    /**
     * 邮政编码
     * @ORM\Column(name="post_code", type="string", length=20)
     */
    private $postCode;

    /**
     * 国际电话区号所在区域
     * @ORM\Column(name="area_code", type="string", length=10)
     */
    private $areaCode;

    /**
     * 电话号码
     * @ORM\Column(name="phone", type="string", length=30)
     */
    private $phone;

    /**
     * 默认收货地址
     * @ORM\Column(name="addr_default", type="integer", length=1)
     */
    private $addrDefault;

    /**
     * 客户id
     * @ORM\Column(name="user_id", type="integer", length=11)
     */
    private $userId;

    /**
     * @return mixed
     */
    public function getAddressId()
    {
        return $this->addressId;
    }

    /**
     * @param mixed $addressId
     */
    public function setAddressId($addressId): void
    {
        $this->addressId = $addressId;
    }

    /**
     * @return mixed
     */
    public function getTrueName()
    {
        return $this->trueName;
    }

    /**
     * @param mixed $trueName
     */
    public function setTrueName($trueName): void
    {
        $this->trueName = $trueName;
    }

    /**
     * @return mixed
     */
    public function getRegionId()
    {
        return $this->regionId;
    }

    /**
     * @param mixed $regionId
     */
    public function setRegionId($regionId): void
    {
        $this->regionId = $regionId;
    }

    /**
     * @return mixed
     */
    public function getRegionValue()
    {
        return $this->regionValue;
    }

    /**
     * @param mixed $regionValue
     */
    public function setRegionValue($regionValue): void
    {
        $this->regionValue = $regionValue;
    }

    /**
     * @return mixed
     */
    public function getAddressInfo()
    {
        return $this->addressInfo;
    }

    /**
     * @param mixed $addressInfo
     */
    public function setAddressInfo($addressInfo): void
    {
        $this->addressInfo = $addressInfo;
    }

    /**
     * @return mixed
     */
    public function getPostCode()
    {
        return $this->postCode;
    }

    /**
     * @param mixed $postCode
     */
    public function setPostCode($postCode): void
    {
        $this->postCode = $postCode;
    }

    /**
     * @return mixed
     */
    public function getAreaCode()
    {
        return $this->areaCode;
    }

    /**
     * @param mixed $areaCode
     */
    public function setAreaCode($areaCode): void
    {
        $this->areaCode = $areaCode;
    }

    /**
     * @return mixed
     */
    public function getPhone()
    {
        return $this->phone;
    }

    /**
     * @param mixed $phone
     */
    public function setPhone($phone): void
    {
        $this->phone = $phone;
    }

    /**
     * @return mixed
     */
    public function getAddrDefault()
    {
        return $this->addrDefault;
    }

    /**
     * @param mixed $addrDefault
     */
    public function setAddrDefault($addrDefault): void
    {
        $this->addrDefault = $addrDefault;
    }

    /**
     * @return mixed
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * @param mixed $userId
     */
    public function setUserId($userId): void
    {
        $this->userId = $userId;
    }
}