<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 客户商品收藏
 * Class UserGoodsFavorites
 * @package User\Entity
 * @ORM\Entity(repositoryClass="User\Repository\UserGoodsFavoritesRepository")
 * @ORM\Table(name="dbshop_user_goods_favorites")
 */
class UserGoodsFavorites extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="goods_favorites_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $goodsFavoritesId;

    /**
     * 商品id
     * @ORM\Column(name="goods_id", type="integer", length=11)
     */
    private $goodsId;

    /**
     * 会员id
     * @ORM\Column(name="user_id", type="integer", length=11)
     */
    private $userId;

    /**
     * 收藏时间
     * @ORM\Column(name="favorites_time", type="integer", length=10)
     */
    private $favoritesTime;

    /**
     * @return mixed
     */
    public function getGoodsFavoritesId()
    {
        return $this->goodsFavoritesId;
    }

    /**
     * @param mixed $goodsFavoritesId
     */
    public function setGoodsFavoritesId($goodsFavoritesId): void
    {
        $this->goodsFavoritesId = $goodsFavoritesId;
    }

    /**
     * @return mixed
     */
    public function getGoodsId()
    {
        return $this->goodsId;
    }

    /**
     * @param mixed $goodsId
     */
    public function setGoodsId($goodsId): void
    {
        $this->goodsId = $goodsId;
    }

    /**
     * @return mixed
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * @param mixed $userId
     */
    public function setUserId($userId): void
    {
        $this->userId = $userId;
    }

    /**
     * @return mixed
     */
    public function getFavoritesTime()
    {
        return $this->favoritesTime;
    }

    /**
     * @param mixed $favoritesTime
     */
    public function setFavoritesTime($favoritesTime): void
    {
        $this->favoritesTime = $favoritesTime;
    }
}