<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 会员组
 * Class UserGroup
 * @package User\Entity
 * @ORM\Entity(repositoryClass="User\Repository\UserGroupRepository")
 * @ORM\Table(name="dbshop_user_group")
 */
class UserGroup extends BaseEntity
{
    /**
     * 客户组id
     * @ORM\Id()
     * @ORM\Column(name="user_group_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $userGroupId;

    /**
     * 客户组名称
     * @ORM\Column(name="user_group_name", type="string", length=150)
     */
    private $userGroupName;

    /**
     * 等级积分开始
     * @ORM\Column(name="integral_start", type="integer", length=11)
     */
    private $integralStart;

    /**
     * 等级积分结束
     * @ORM\Column(name="integral_end", type="integer", length=11)
     */
    private $integralEnd;

    /**
     * 客户组积分状态，1 开启，2 关闭
     * @ORM\Column(name="integral_state", type="integer", length=1)
     */
    private $integralState;

    /**
     * @return mixed
     */
    public function getUserGroupId()
    {
        return $this->userGroupId;
    }

    /**
     * @param mixed $userGroupId
     */
    public function setUserGroupId($userGroupId): void
    {
        $this->userGroupId = $userGroupId;
    }

    /**
     * @return mixed
     */
    public function getUserGroupName()
    {
        return $this->userGroupName;
    }

    /**
     * @param mixed $userGroupName
     */
    public function setUserGroupName($userGroupName): void
    {
        $this->userGroupName = $userGroupName;
    }

    /**
     * @return mixed
     */
    public function getIntegralStart()
    {
        return $this->integralStart;
    }

    /**
     * @param mixed $integralStart
     */
    public function setIntegralStart($integralStart): void
    {
        $this->integralStart = $integralStart;
    }

    /**
     * @return mixed
     */
    public function getIntegralEnd()
    {
        return $this->integralEnd;
    }

    /**
     * @param mixed $integralEnd
     */
    public function setIntegralEnd($integralEnd): void
    {
        $this->integralEnd = $integralEnd;
    }

    /**
     * @return mixed
     */
    public function getIntegralState()
    {
        return $this->integralState;
    }

    /**
     * @param mixed $integralState
     */
    public function setIntegralState($integralState): void
    {
        $this->integralState = $integralState;
    }
}