<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 需要确认才能获取的积分表，如 购物获取积分需要确认收货才可以获得
 * Class UserIntegralConfirm
 * @package User\Entity
 * @ORM\Entity(repositoryClass="User\Repository\UserIntegralConfirmRepository")
 * @ORM\Table(name="dbshop_user_integral_confirm")
 */
class UserIntegralConfirm extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="confirm_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $confirmId;

    /**
     * 消费积分
     * @ORM\Column(name="integral_type1_num", type="integer", length=11)
     */
    private $integralType1Num = 0;

    /**
     * 等级积分
     * @ORM\Column(name="integral_type2_num", type="integer", length=11)
     */
    private $integralType2Num = 0;

    /**
     * 会员id
     * @ORM\Column(name="user_id", type="integer", length=11)
     */
    private $userId;

    /**
     * 对应的id信息，如通过订单获取的，则这里就是订单id
     * @ORM\Column(name="id", type="integer", length=11)
     */
    private $id;

    /**
     * 确认类型，order 订单，
     * @ORM\Column(name="confirm_type", type="string", length=20)
     */
    private $confirmType;

    /**
     * 确认状态，0 待确认，1 获取积分，2 退还积分
     * @ORM\Column(name="confirm_state", type="integer", length=1)
     */
    private $confirmState = 0;

    /**
     * 记录添加时间
     * @ORM\Column(name="add_time", type="integer", length=10)
     */
    private $addTime;

    /**
     * 确认时间
     * @ORM\Column(name="confirm_time", type="integer", length=10)
     */
    private $confirmTime = 0;

    /**
     * @return mixed
     */
    public function getConfirmId()
    {
        return $this->confirmId;
    }

    /**
     * @param mixed $confirmId
     */
    public function setConfirmId($confirmId): void
    {
        $this->confirmId = $confirmId;
    }

    /**
     * @return mixed
     */
    public function getIntegralType1Num()
    {
        return $this->integralType1Num;
    }

    /**
     * @param mixed $integralType1Num
     */
    public function setIntegralType1Num($integralType1Num): void
    {
        $this->integralType1Num = $integralType1Num;
    }

    /**
     * @return mixed
     */
    public function getIntegralType2Num()
    {
        return $this->integralType2Num;
    }

    /**
     * @param mixed $integralType2Num
     */
    public function setIntegralType2Num($integralType2Num): void
    {
        $this->integralType2Num = $integralType2Num;
    }

    /**
     * @return mixed
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * @param mixed $userId
     */
    public function setUserId($userId): void
    {
        $this->userId = $userId;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId($id): void
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getConfirmType()
    {
        return $this->confirmType;
    }

    /**
     * @param mixed $confirmType
     */
    public function setConfirmType($confirmType): void
    {
        $this->confirmType = $confirmType;
    }

    /**
     * @return mixed
     */
    public function getConfirmState()
    {
        return $this->confirmState;
    }

    /**
     * @param mixed $confirmState
     */
    public function setConfirmState($confirmState): void
    {
        $this->confirmState = $confirmState;
    }

    /**
     * @return mixed
     */
    public function getAddTime()
    {
        return $this->addTime;
    }

    /**
     * @param mixed $addTime
     */
    public function setAddTime($addTime): void
    {
        $this->addTime = $addTime;
    }

    /**
     * @return mixed
     */
    public function getConfirmTime()
    {
        return $this->confirmTime;
    }

    /**
     * @param mixed $confirmTime
     */
    public function setConfirmTime($confirmTime): void
    {
        $this->confirmTime = $confirmTime;
    }
}