<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 第三方授权登录
 * Class UserOtherLogin
 * @package User\Entity
 * @ORM\Entity(repositoryClass="User\Repository\UserOtherLoginRepository")
 * @ORM\Table(name="dbshop_user_other_login")
 */
class UserOtherLogin extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="ol_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $olId;

    /**
     * 会员id
     * @ORM\Column(name="user_id", type="integer", length=11)
     */
    private $userId;

    /**
     * 唯一id
     * @ORM\Column(name="open_id", type="string", length=100)
     */
    private $openId;

    /**
     * 唯一id，非必须当存在时，可保存
     * @ORM\Column(name="union_id", type="string", length=100)
     */
    private $unionId;

    /**
     * 添加时间
     * @ORM\Column(name="ol_add_time", type="integer", length=10)
     */
    private $olAddTime;

    /**
     * 登录类型，如果 微信 wechat
     * @ORM\Column(name="login_type", type="string", length=30)
     */
    private $loginType;

    /**
     * @return mixed
     */
    public function getOlId()
    {
        return $this->olId;
    }

    /**
     * @param mixed $olId
     */
    public function setOlId($olId): void
    {
        $this->olId = $olId;
    }

    /**
     * @return mixed
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * @param mixed $userId
     */
    public function setUserId($userId): void
    {
        $this->userId = $userId;
    }

    /**
     * @return mixed
     */
    public function getOpenId()
    {
        return $this->openId;
    }

    /**
     * @param mixed $openId
     */
    public function setOpenId($openId): void
    {
        $this->openId = $openId;
    }

    /**
     * @return mixed
     */
    public function getUnionId()
    {
        return $this->unionId;
    }

    /**
     * @param mixed $unionId
     */
    public function setUnionId($unionId): void
    {
        $this->unionId = $unionId;
    }

    /**
     * @return mixed
     */
    public function getOlAddTime()
    {
        return $this->olAddTime;
    }

    /**
     * @param mixed $olAddTime
     */
    public function setOlAddTime($olAddTime): void
    {
        $this->olAddTime = $olAddTime;
    }

    /**
     * @return mixed
     */
    public function getLoginType()
    {
        return $this->loginType;
    }

    /**
     * @param mixed $loginType
     */
    public function setLoginType($loginType): void
    {
        $this->loginType = $loginType;
    }
}