<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 会员充值
 * Class UserRecharge
 * @package User\Entity
 * @ORM\Entity(repositoryClass="User\Repository\UserRechargeRepository")
 * @ORM\Table(name="dbshop_user_recharge")
 */
class UserRecharge extends BaseEntity
{
    /**
     * 自增id
     * @var int
     * @ORM\Id()
     * @ORM\Column(name="recharge_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $rechargeId;

    /**
     * 会员id
     * @ORM\Column(name="user_id", type="integer", length=11)
     */
    private $userId;

    /**
     * 会员名称
     * @ORM\Column(name="user_name", type="string", length=100)
     */
    private $userName;

    /**
     * 充值金额（对应货币的金额）
     * @ORM\Column(name="recharge_num", type="decimal", scale=2)
     */
    private $rechargeNum;

    /**
     * 充值货币编码
     * @ORM\Column(name="currency_code", type="string", length=5)
     */
    private $currencyCode;

    /**
     * 货币汇率（与基础货币相比）
     * @ORM\Column(name="currency_rate", type="string", length=10)
     */
    private $currencyRate;

    /**
     * 基础货币充值金额（真正充值进余额的金额）
     * @ORM\Column(name="base_recharge_num", type="decimal", scale=2)
     */
    private $baseRechargeNum;

    /**
     * 基础货币编码
     * @ORM\Column(name="base_currency_code", type="string", length=5)
     */
    private $baseCurrencyCode;

    /**
     * 充值状态，10 待支付 20 支付完成
     * @ORM\Column(name="pay_state", type="integer", length=2)
     */
    private $payState;

    /**
     * 充值的支付方式编码
     * @ORM\Column(name="pay_code", type="string", length=30)
     */
    private $payCode;

    /**
     * 充值的支付方式名称
     * @ORM\Column(name="pay_name", type="string", length=100)
     */
    private $payName;

    /**
     * 添加充值时间
     * @ORM\Column(name="add_recharge_time", type="integer", length=10)
     */
    private $addRechargeTime;

    /**
     * 完成充值时间
     * @ORM\Column(name="finish_recharge_time", type="integer", length=10)
     */
    private $finishRechargeTime;

    /**
     * @return int
     */
    public function getRechargeId(): int
    {
        return $this->rechargeId;
    }

    /**
     * @param int $rechargeId
     */
    public function setRechargeId(int $rechargeId): void
    {
        $this->rechargeId = $rechargeId;
    }

    /**
     * @return mixed
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * @param mixed $userId
     */
    public function setUserId($userId): void
    {
        $this->userId = $userId;
    }

    /**
     * @return mixed
     */
    public function getUserName()
    {
        return $this->userName;
    }

    /**
     * @param mixed $userName
     */
    public function setUserName($userName): void
    {
        $this->userName = $userName;
    }

    /**
     * @return mixed
     */
    public function getRechargeNum()
    {
        return $this->rechargeNum;
    }

    /**
     * @param mixed $rechargeNum
     */
    public function setRechargeNum($rechargeNum): void
    {
        $this->rechargeNum = $rechargeNum;
    }

    /**
     * @return mixed
     */
    public function getCurrencyCode()
    {
        return $this->currencyCode;
    }

    /**
     * @param mixed $currencyCode
     */
    public function setCurrencyCode($currencyCode): void
    {
        $this->currencyCode = $currencyCode;
    }

    /**
     * @return mixed
     */
    public function getCurrencyRate()
    {
        return $this->currencyRate;
    }

    /**
     * @param mixed $currencyRate
     */
    public function setCurrencyRate($currencyRate): void
    {
        $this->currencyRate = $currencyRate;
    }

    /**
     * @return mixed
     */
    public function getBaseRechargeNum()
    {
        return $this->baseRechargeNum;
    }

    /**
     * @param mixed $baseRechargeNum
     */
    public function setBaseRechargeNum($baseRechargeNum): void
    {
        $this->baseRechargeNum = $baseRechargeNum;
    }

    /**
     * @return mixed
     */
    public function getBaseCurrencyCode()
    {
        return $this->baseCurrencyCode;
    }

    /**
     * @param mixed $baseCurrencyCode
     */
    public function setBaseCurrencyCode($baseCurrencyCode): void
    {
        $this->baseCurrencyCode = $baseCurrencyCode;
    }

    /**
     * @return mixed
     */
    public function getPayState()
    {
        return $this->payState;
    }

    /**
     * @param mixed $payState
     */
    public function setPayState($payState): void
    {
        $this->payState = $payState;
    }

    /**
     * @return mixed
     */
    public function getPayCode()
    {
        return $this->payCode;
    }

    /**
     * @param mixed $payCode
     */
    public function setPayCode($payCode): void
    {
        $this->payCode = $payCode;
    }

    /**
     * @return mixed
     */
    public function getPayName()
    {
        return $this->payName;
    }

    /**
     * @param mixed $payName
     */
    public function setPayName($payName): void
    {
        $this->payName = $payName;
    }

    /**
     * @return mixed
     */
    public function getAddRechargeTime()
    {
        return $this->addRechargeTime;
    }

    /**
     * @param mixed $addRechargeTime
     */
    public function setAddRechargeTime($addRechargeTime): void
    {
        $this->addRechargeTime = $addRechargeTime;
    }

    /**
     * @return mixed
     */
    public function getFinishRechargeTime()
    {
        return $this->finishRechargeTime;
    }

    /**
     * @param mixed $finishRechargeTime
     */
    public function setFinishRechargeTime($finishRechargeTime): void
    {
        $this->finishRechargeTime = $finishRechargeTime;
    }
}