<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Entity;

use Admin\Entity\BaseEntity;
use Doctrine\ORM\Mapping as ORM;

/**
 * 会员提现
 * Class UserWithdraw
 * @package User\Entity
 * @ORM\Entity(repositoryClass="User\Repository\UserWithdrawRepository")
 * @ORM\Table(name="dbshop_user_withdraw")
 */
class UserWithdraw extends BaseEntity
{
    /**
     * 自增id
     * @ORM\Id()
     * @ORM\Column(name="withdraw_id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $withdrawId;

    /**
     * 申请人id
     * @ORM\Column(name="user_id", type="integer", length=11)
     */
    private $userId;

    /**
     * 申请人名称
     * @ORM\Column(name="user_name", type="string", length=100)
     */
    private $userName;

    /**
     * 提现金额
     * @ORM\Column(name="money_change_num", type="decimal", scale=2)
     */
    private $moneyChangeNum;

    /**
     * 货币编码
     * @ORM\Column(name="currency_code", type="string", length=10)
     */
    private $currencyCode;

    /**
     * 开户银行/支付名称
     * @ORM\Column(name="bank_name", type="string", length=100)
     */
    private $bankName;

    /**
     * 账户名称/开户名称
     * @ORM\Column(name="bank_account", type="string", length=50)
     */
    private $bankAccount;

    /**
     * 账号/卡号
     * @ORM\Column(name="bank_card_number", type="string", length=100)
     */
    private $bankCardNumber;

    /**
     * 提现处理备注
     * @ORM\Column(name="withdraw_info", type="string", length=500)
     */
    private $withdrawInfo;

    /**
     * 提现申请时间
     * @ORM\Column(name="add_withdraw_time", type="integer", length=10)
     */
    private $addWithdrawTime;

    /**
     * 提现状态，1 申请，2 审核通过，3 拒绝
     * @ORM\Column(name="withdraw_state", type="integer", length=1)
     */
    private $withdrawState = 1;

    /**
     * 提现处理时间
     * @ORM\Column(name="withdraw_finish_time", type="integer", length=10)
     */
    private $withdrawFinishTime;

    /**
     * 管理员id
     * @ORM\Column(name="admin_id", type="integer", length=11)
     */
    private $adminId = 0;

    /**
     * 管理员名称
     * @ORM\Column(name="admin_name", type="string", length=100)
     */
    private $adminName = '';

    /**
     * @return mixed
     */
    public function getWithdrawId()
    {
        return $this->withdrawId;
    }

    /**
     * @param mixed $withdrawId
     */
    public function setWithdrawId($withdrawId): void
    {
        $this->withdrawId = $withdrawId;
    }

    /**
     * @return mixed
     */
    public function getUserId()
    {
        return $this->userId;
    }

    /**
     * @param mixed $userId
     */
    public function setUserId($userId): void
    {
        $this->userId = $userId;
    }

    /**
     * @return mixed
     */
    public function getUserName()
    {
        return $this->userName;
    }

    /**
     * @param mixed $userName
     */
    public function setUserName($userName): void
    {
        $this->userName = $userName;
    }

    /**
     * @return mixed
     */
    public function getMoneyChangeNum()
    {
        return $this->moneyChangeNum;
    }

    /**
     * @param mixed $moneyChangeNum
     */
    public function setMoneyChangeNum($moneyChangeNum): void
    {
        $this->moneyChangeNum = $moneyChangeNum;
    }

    /**
     * @return mixed
     */
    public function getCurrencyCode()
    {
        return $this->currencyCode;
    }

    /**
     * @param mixed $currencyCode
     */
    public function setCurrencyCode($currencyCode): void
    {
        $this->currencyCode = $currencyCode;
    }

    /**
     * @return mixed
     */
    public function getBankName()
    {
        return $this->bankName;
    }

    /**
     * @param mixed $bankName
     */
    public function setBankName($bankName): void
    {
        $this->bankName = $bankName;
    }

    /**
     * @return mixed
     */
    public function getBankAccount()
    {
        return $this->bankAccount;
    }

    /**
     * @param mixed $bankAccount
     */
    public function setBankAccount($bankAccount): void
    {
        $this->bankAccount = $bankAccount;
    }

    /**
     * @return mixed
     */
    public function getBankCardNumber()
    {
        return $this->bankCardNumber;
    }

    /**
     * @param mixed $bankCardNumber
     */
    public function setBankCardNumber($bankCardNumber): void
    {
        $this->bankCardNumber = $bankCardNumber;
    }

    /**
     * @return mixed
     */
    public function getWithdrawInfo()
    {
        return $this->withdrawInfo;
    }

    /**
     * @param mixed $withdrawInfo
     */
    public function setWithdrawInfo($withdrawInfo): void
    {
        $this->withdrawInfo = $withdrawInfo;
    }

    /**
     * @return mixed
     */
    public function getAddWithdrawTime()
    {
        return $this->addWithdrawTime;
    }

    /**
     * @param mixed $addWithdrawTime
     */
    public function setAddWithdrawTime($addWithdrawTime): void
    {
        $this->addWithdrawTime = $addWithdrawTime;
    }

    /**
     * @return mixed
     */
    public function getWithdrawState()
    {
        return $this->withdrawState;
    }

    /**
     * @param mixed $withdrawState
     */
    public function setWithdrawState($withdrawState): void
    {
        $this->withdrawState = $withdrawState;
    }

    /**
     * @return mixed
     */
    public function getWithdrawFinishTime()
    {
        return $this->withdrawFinishTime;
    }

    /**
     * @param mixed $withdrawFinishTime
     */
    public function setWithdrawFinishTime($withdrawFinishTime): void
    {
        $this->withdrawFinishTime = $withdrawFinishTime;
    }

    /**
     * @return mixed
     */
    public function getAdminId()
    {
        return $this->adminId;
    }

    /**
     * @param mixed $adminId
     */
    public function setAdminId($adminId): void
    {
        $this->adminId = $adminId;
    }

    /**
     * @return mixed
     */
    public function getAdminName()
    {
        return $this->adminName;
    }

    /**
     * @param mixed $adminName
     */
    public function setAdminName($adminName): void
    {
        $this->adminName = $adminName;
    }
}