<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Event\Factory;

use Admin\Data\Config;
use Interop\Container\ContainerInterface;
use User\Event\UserListener;
use User\Service\CartManager;
use User\Service\IntegralLogManager;
use User\Service\UserManager;
use Laminas\ServiceManager\Factory\FactoryInterface;

class UserListenerFactory implements FactoryInterface
{
    public function __invoke(ContainerInterface $container, $requestedName, array $options = null)
    {
        $entityManager  = $container->get(Config::SHOP_DATABASE_MANAGER_WRITE);
        $userManager    = $container->get(UserManager::class);
        $integralLogManager = $container->get(IntegralLogManager::class);
        $cartManager    = $container->get(CartManager::class);

        return new UserListener($entityManager, $userManager, $integralLogManager, $cartManager);
    }
}