<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Form;

use Admin\Data\Config;
use Laminas\Form\Form;

class ChangeUserPasswordForm extends Form
{
    public function __construct($name = 'user-change-password-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'password',
            'name'  => 'userPassword',
            'attributes'    => [
                'id'            => 'userPassword',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'password',
            'name'  => 'userComPassword',
            'attributes'    => [
                'id'            => 'userComPassword',
                'class'         => 'form-control'
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'userPassword',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 6
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'userComPassword',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim']
            ],
            'validators'=> [
                [
                    'name'      => 'Identical',
                    'options'   => [
                        'token' => 'userPassword'
                    ]
                ]
            ]
        ]);
    }
}