<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Form;

use Laminas\Form\Form;
use User\Validator\UserEditBalanceValidator;

class EditUserBalanceForm extends Form
{
    private $userInfo;

    public function __construct($userInfo, $name = 'edit-user-balance-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');

        $this->userInfo = $userInfo;

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'userName',
            'attributes'    => [
                'id'            => 'userName',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'changeBalance',
            'attributes'    => [
                'id'            => 'changeBalance',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'changeBalanceNum',
            'attributes'    => [
                'id'            => 'changeBalanceNum',
                'class'         => 'form-control',
                 'value'        => 1
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'changeBalanceInfo',
            'attributes'    => [
                'id'    => 'changeBalanceInfo',
                'class' => 'form-control',
                'rows'  => 3
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'changeBalance',
            'required'  => true,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => ['+', '-']
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'changeBalanceNum',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToFloat']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0,
                        //'inclusive' => true
                    ]
                ],
                [
                    'name' => UserEditBalanceValidator::class,
                    'options' => [
                        'userInfo' => $this->userInfo
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'changeBalanceInfo',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);
    }
}