<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Form;

use User\Validator\UserIntegralType1Validator;
use User\Validator\UserIntegralType2Validator;
use Laminas\Form\Form;

class EditUserIntegralForm extends Form
{
    private $userInfo;

    public function __construct($userInfo, $name = 'edit-user-integral-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');

        $this->userInfo = $userInfo;

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'userName',
            'attributes'    => [
                'id'            => 'userName',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'changeIntegral1',
            'attributes'    => [
                'id'            => 'changeIntegral1',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'changeIntegral1Num',
            'attributes'    => [
                'id'            => 'changeIntegral1Num',
                'class'         => 'form-control',
                'min'   => 0
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'changeIntegral2',
            'attributes'    => [
                'id'            => 'changeIntegral2',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'changeIntegral2Num',
            'attributes'    => [
                'id'            => 'changeIntegral2Num',
                'class'         => 'form-control',
                'min'   => 0
            ]
        ]);

        $this->add([
            'type'  => 'textarea',
            'name'  => 'integralLogInfo',
            'attributes'    => [
                'id'    => 'integralLogInfo',
                'class' => 'form-control',
                'rows'  => 3
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'changeIntegral1',
            'required'  => true,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => ['+', '-']
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'changeIntegral1Num',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0,
                        'inclusive' => true
                    ]
                ],
                [
                    'name' => UserIntegralType1Validator::class,
                    'options' => [
                        'userInfo' => $this->userInfo
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'changeIntegral2',
            'required'  => true,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => ['+', '-']
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'changeIntegral2Num',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0,
                        'inclusive' => true
                    ]
                ],
                [
                    'name' => UserIntegralType2Validator::class,
                    'options' => [
                        'userInfo' => $this->userInfo
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'integralLogInfo',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);
    }
}