<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Form;

use Laminas\Form\Form;

class IntegralRuleForm extends Form
{
    public function __construct($name = 'user-integral-form', $options = [])
    {
        parent::__construct($name, $options);
        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'integralRuleTitle',
            'attributes'    => [
                'id'            => 'integralRuleTitle',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'integralRuleInfo',
            'attributes'    => [
                'id'            => 'integralRuleInfo',
                'class'         => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'integralRuleStartTime',
            'attributes'    => [
                'id'    => 'integralRuleStartTime',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'integralRuleEndTime',
            'attributes'    => [
                'id'    => 'integralRuleEndTime',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'checkbox',
            'name'  => 'integralRuleState',
            'attributes'    => [
                'id'    => 'integralRuleState',
                'value' => 1
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'integralRuleType',
            'attributes'    => [
                'id'    => 'integralRuleType',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'integralTypeId',
            'attributes'    => [
                'id'    => 'integralTypeId',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'integralNum',
            'attributes'    => [
                'id'    => 'integralNum',
                'class' => 'form-control',
                'min'   => 1,
                'value' => 1
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'integralRuleUserType',
            'attributes'    => [
                'id'    => 'integralRuleUserType',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'multiCheckbox',
            'name'  => 'userGroup',
            'options'    => [
                'label_attributes' => [
                    'class' => 'checkbox-inline'
                ]
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'integralRuleGoodsType',
            'attributes'    => [
                'id'    => 'integralRuleGoodsType',
                'class' => 'form-control'
            ]
        ]);

        $this->add([
            'type'  => 'multiCheckbox',
            'name'  => 'goodsClass'
        ]);

        $this->add([
            'type'  => 'multiCheckbox',
            'name'  => 'goodsBrand'
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'integralRuleTitle',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'integralRuleInfo',
            'required'  => true,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'integralRuleStartTime',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'integralRuleEndTime',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'integralRuleState',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [0, 1]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'integralNum',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 1,
                        'inclusive' => true
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'userGroup',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goodsClass',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'goodsBrand',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);
    }
}