<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Form;

use Laminas\Form\Form;

class IntegralTypeForm extends Form
{
    private $integralTypeInfo;

    public function __construct($integralTypeInfo = null, $name = 'integral-type-edit-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'post');
        $this->setAttribute('class', 'form-horizontal');

        $this->integralTypeInfo = $integralTypeInfo;

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'integralTypeName',
            'attributes'    => [
                'id'            => 'integralTypeName',
                'class'         => 'form-control'
            ]
        ]);

        if($this->integralTypeInfo && $this->integralTypeInfo->getIntegralTypeId() == 1) {
            $this->add([
                'type'  => 'number',
                'name'  => 'integralCurrencyCon',
                'attributes'    => [
                    'id'    => 'integralCurrencyCon',
                    'class' => 'form-control',
                    'min'   => 1
                ]
            ]);
        }

        $this->add([
            'type'  => 'number',
            'name'  => 'integralDefaultNum',
            'attributes'    => [
                'id'    => 'integralDefaultNum',
                'class' => 'form-control',
                'min'   => 0
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'integralTypeName',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ],
            'validators'=> [
                [
                    'name'      => 'StringLength',
                    'options'   => [
                        'min'   => 1,
                        'max'   => 100
                    ]
                ]
            ]
        ]);

        if($this->integralTypeInfo && $this->integralTypeInfo->getIntegralTypeId() == 1) {
            $inputFilter->add([
                'name'      => 'integralCurrencyCon',
                'required'  => false,
                'filters'   => [
                    ['name' => 'ToInt']
                ],
                'validators'=> [
                    [
                        'name'      => 'GreaterThan',
                        'options'   => [
                            'min'   => 1,
                            'inclusive' => true
                        ]
                    ]
                ]
            ]);
        }

        $inputFilter->add([
            'name'      => 'integralDefaultNum',
            'required'  => true,
            'filters'   => [
                ['name' => 'ToInt']
            ],
            'validators'=> [
                [
                    'name'      => 'GreaterThan',
                    'options'   => [
                        'min'   => 0,
                        'inclusive' => true
                    ]
                ]
            ]
        ]);
    }
}