<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Form;

use Laminas\Form\Form;
use Laminas\I18n\Translator\Translator;

class SearchBalanceLogForm extends Form
{
    private $translator;

    public function __construct($name = 'search-balance-log-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'get');
        $this->setAttribute('class', 'form-horizontal');

        $this->translator = new Translator();

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'user_name',
            'attributes'    => [
                'id'            => 'user_name',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('客户名称')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'balance_change_num',
            'attributes'    => [
                'id'            => 'balance_change_num',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('处理金额')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'balance_changed_amount',
            'attributes'    => [
                'id'            => 'balance_changed_amount',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('账户余额')
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'balance_change_type',
            'attributes'    => [
                'id'            => 'balance_change_type',
                'class'         => 'form-control input-sm'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'search_name',
            'attributes'    => [
                'id'            => 'search_name',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('操作者')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'balance_change_info',
            'attributes'    => [
                'id'            => 'balance_change_info',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('备注信息')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'start_time',
            'attributes'    => [
                'id'            => 'start_time',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('起始时间')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'end_time',
            'attributes'    => [
                'id'            => 'end_time',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('结束时间')
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'user_name',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'balance_change_num',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToFloat']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'balance_changed_amount',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToFloat']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'balance_change_type',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'search_name',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'balance_change_info',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'start_time',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'end_time',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags']
            ]
        ]);
    }
}