<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Form;

use Laminas\Form\Form;
use Laminas\I18n\Translator\Translator;

class SearchIntegralLogForm extends Form
{
    private $translator;

    public function __construct($name = 'search-integral-log-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'get');
        $this->setAttribute('class', 'form-horizontal');

        $this->translator = new Translator();

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'user_name',
            'attributes'    => [
                'id'            => 'user_name',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('客户名称')
            ]
        ]);

        $this->add([
            'type'  => 'number',
            'name'  => 'change_integral_num',
            'attributes'    => [
                'id'            => 'change_integral_num',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('积分')
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'integral_type_id',
            'attributes'    => [
                'id'            => 'integral_type_id',
                'class'         => 'form-control input-sm'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'oper_name',
            'attributes'    => [
                'id'            => 'oper_name',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('操作者')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'integral_log_info',
            'attributes'    => [
                'id'            => 'integral_log_info',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('描述内容')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'start_time',
            'attributes'    => [
                'id'            => 'start_time',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('起始时间')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'end_time',
            'attributes'    => [
                'id'            => 'end_time',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('结束时间')
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'user_name',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'change_integral_num',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'oper_name',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'integral_log_info',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'integral_type_id',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'start_time',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'end_time',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags']
            ]
        ]);
    }
}