<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Form;

use Laminas\Form\Form;
use Laminas\I18n\Translator\Translator;

class SearchRechargeForm extends Form
{
    private $translator;

    public function __construct($name = 'search-recharge-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'get');
        $this->setAttribute('class', 'form-horizontal');

        $this->translator = new Translator();

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'add_start_time',
            'attributes'    => [
                'id'            => 'add_start_time',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('起始时间')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'add_end_time',
            'attributes'    => [
                'id'            => 'add_end_time',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('结束时间')
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'pay_state',
            'attributes'    => [
                'id'            => 'pay_state',
                'class'         => 'form-control input-sm'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'user_name',
            'attributes'    => [
                'id'            => 'user_name',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('充值人名称')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'pay_name',
            'attributes'    => [
                'id'            => 'pay_name',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('支付方式名称')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'recharge_num',
            'attributes'    => [
                'id'            => 'recharge_num',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('充值金额')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'base_recharge_num',
            'attributes'    => [
                'id'            => 'base_recharge_num',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('实存金额')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'finish_start_time',
            'attributes'    => [
                'id'            => 'finish_start_time',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('起始时间')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'finish_end_time',
            'attributes'    => [
                'id'            => 'finish_end_time',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('结束时间')
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'add_start_time',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'add_end_time',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'pay_state',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'user_name',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'pay_name',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'recharge_num',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToFloat']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'base_recharge_num',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToFloat']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'finish_start_time',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'finish_end_time',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags']
            ]
        ]);
    }
}