<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Form;

use Laminas\Form\Form;
use Laminas\I18n\Translator\Translator;

class SearchUserForm extends Form
{
    private $translator;

    public function __construct($name = 'search-user-form', $options = [])
    {
        parent::__construct($name, $options);

        $this->setAttribute('method', 'get');
        $this->setAttribute('class', 'form-horizontal');

        $this->translator = new Translator();

        $this->addElements();
        $this->addInputFilter();
    }

    protected function addElements()
    {
        $this->add([
            'type'  => 'text',
            'name'  => 'start_id',
            'attributes'    => [
                'id'            => 'start_id',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('起始ID')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'end_id',
            'attributes'    => [
                'id'            => 'end_id',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('结束ID')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'user_name',
            'attributes'    => [
                'id'            => 'user_name',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('客户名称')
            ]
        ]);

        $this->add([
            'type'  => 'email',
            'name'  => 'user_email',
            'attributes'    => [
                'id'            => 'user_email',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('电子邮箱')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'user_phone',
            'attributes'    => [
                'id'            => 'user_phone',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('手机号码')
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'user_group_id',
            'attributes'    => [
                'id'            => 'user_group_id',
                'class'         => 'form-control input-sm'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'user_money',
            'attributes'    => [
                'id'            => 'user_money',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('余额')
            ]
        ]);

        $this->add([
            'type'  => 'select',
            'name'  => 'user_status',
            'attributes'    => [
                'id'            => 'user_status',
                'class'         => 'form-control input-sm'
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'start_time',
            'attributes'    => [
                'id'            => 'start_time',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('起始时间')
            ]
        ]);

        $this->add([
            'type'  => 'text',
            'name'  => 'end_time',
            'attributes'    => [
                'id'            => 'end_time',
                'class'         => 'form-control input-sm',
                'placeholder'   => $this->translator->translate('结束时间')
            ]
        ]);
    }

    protected function addInputFilter()
    {
        $inputFilter = $this->getInputFilter();

        $inputFilter->add([
            'name'      => 'start_id',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'end_id',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToInt']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'user_name',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'user_email',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'user_phone',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags'],
                ['name' => 'HtmlEntities']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'user_group_id',
            'required'  => false
        ]);

        $inputFilter->add([
            'name'      => 'user_money',
            'required'  => false,
            'filters'   => [
                ['name' => 'ToFloat']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'user_status',
            'required'  => false,
            'validators'=> [
                [
                    'name'      => 'InArray',
                    'options'   => [
                        'haystack'  => [1, 2, 3]
                    ]
                ]
            ]
        ]);

        $inputFilter->add([
            'name'      => 'start_time',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags']
            ]
        ]);

        $inputFilter->add([
            'name'      => 'end_time',
            'required'  => false,
            'filters'   => [
                ['name' => 'StringTrim'],
                ['name' => 'StripTags']
            ]
        ]);
    }
}