<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Plugin;

use Doctrine\ORM\EntityManager;
use User\Entity\UserGroup;
use Laminas\Mvc\Controller\Plugin\AbstractPlugin;
use Laminas\Mvc\I18n\Translator;

class UserPlugin extends AbstractPlugin
{
    private $entityManager;
    private $translator;

    public function __construct(
        EntityManager   $entityManager,
        Translator      $translator
    )
    {
        $this->entityManager    = $entityManager;
        $this->translator       = $translator;
    }

    /**
     * 获取客户组列表
     * @param string $topName
     * @param bool $haveState
     * @return array
     */
    /**
     * 获取客户组列表
     * @param string $topName
     * @param bool $haveState
     * @param false $noIntegralGroup true 只显示未启用的积分客户组，false 全部显示
     * @return array|string[]
     */
    public function userGroupOptions($topName = '', $haveState = true, $noIntegralGroup = false)
    {
        $userGroupList = [];
        if($haveState) $userGroupList  = ['' => empty($topName) ? $this->translator->translate('===选择客户组===') : $topName];
        $groupList      = $this->entityManager->getRepository(UserGroup::class)->findAll();
        if($groupList) {
            foreach ($groupList as $group) {
                if ($noIntegralGroup && $group->getIntegralState() == 1) continue;
                $userGroupList[$group->getUserGroupId()] = $group->getUserGroupName();
            }
        }

        return $userGroupList;
    }
}