<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Repository;

use Doctrine\ORM\EntityRepository;
use User\Entity\BalanceLog;
use User\Repository\QuerySearch\BalanceLogSearch;

class BalanceLogRepository extends EntityRepository
{
    /**
     * 余额记录列表
     * @param array $search
     * @return \Doctrine\ORM\Query
     */
    public function findUserBalanceLog(array $search = [])
    {
        $query = $this->getEntityManager()->createQueryBuilder()
            ->select('o')
            ->from(BalanceLog::class, 'o')
            ->orderBy('o.balanceLogId', 'DESC');

        $query = BalanceLogSearch::querySearchData($search, $query);

        return $query->getQuery();
    }

    /*==============================================下面为前台调用==============================================*/

    /**
     * 前台余额记录列表
     * @param $userId
     * @param array $search
     * @return \Doctrine\ORM\Query
     */
    public function shopFindUserBalanceLog($userId, array $search = [])
    {
        $query = $this->getEntityManager()->createQueryBuilder()
            ->select('o')
            ->from(BalanceLog::class, 'o')
            ->where('o.userId = :userId')->setParameter('userId', $userId)
            ->orderBy('o.balanceLogId', 'DESC');

        $query = BalanceLogSearch::shopQuerySearchData($search, $query);

        return $query->getQuery();
    }
}