<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Repository;

use Doctrine\ORM\EntityRepository;
use User\Entity\IntegralLog;
use User\Repository\QuerySearch\IntegralLogSearch;

class IntegralLogRepository extends EntityRepository
{
    /**
     * 积分记录列表
     * @param array $search
     * @return \Doctrine\ORM\Query
     */
    public function findUserIntegralLog(array $search = [])
    {
        $query = $this->getEntityManager()->createQueryBuilder()
            ->select('o')
            ->from(IntegralLog::class, 'o')
            ->orderBy('o.integralLogId', 'DESC');

        $query = IntegralLogSearch::querySearchData($search, $query);

        return $query->getQuery();
    }

    /*==============================================下面为前台调用==============================================*/

    /**
     * 前台积分记录列表
     * @param $userId
     * @param array $search
     * @return \Doctrine\ORM\Query
     */
    public function shopFindUserIntegralLog($userId, array $search = [])
    {
        $query = $this->getEntityManager()->createQueryBuilder()
            ->select('o')
            ->from(IntegralLog::class, 'o')
            ->where('o.userId = :userId')->setParameter('userId', $userId)
            ->orderBy('o.integralLogId', 'DESC');

        $query = IntegralLogSearch::shopQuerySearchData($search, $query);

        return $query->getQuery();
    }
}