<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Repository\QuerySearch;

use Doctrine\ORM\QueryBuilder;

class BalanceLogSearch
{
    /**
     * 对检索信息进行处理
     * @param $search
     * @param QueryBuilder $queryBuilder
     * @return QueryBuilder
     */
    public static function querySearchData($search, QueryBuilder $queryBuilder)
    {
        if(isset($search['user_name']) && !empty($search['user_name']))                         $queryBuilder->andWhere($queryBuilder->expr()->eq('o.userName', ':userName'))->setParameter('userName', $search['user_name']);
        if(isset($search['balance_change_type']) && $search['balance_change_type'] > 0)         $queryBuilder->andWhere($queryBuilder->expr()->eq('o.balanceChangeType', $search['balance_change_type']));
        if(isset($search['balance_change_num']) && $search['balance_change_num'] != 0)          $queryBuilder->andWhere($queryBuilder->expr()->eq('o.balanceChangeNum', $search['balance_change_num']));
        if(isset($search['balance_changed_amount']) && $search['balance_changed_amount'] != 0)  $queryBuilder->andWhere($queryBuilder->expr()->eq('o.balanceChangedAmount', $search['balance_changed_amount']));
        if(isset($search['start_time']) && !empty($search['start_time']))                       $queryBuilder->andWhere($queryBuilder->expr()->gte('o.balanceChangeTime', ':startTime'))->setParameter('startTime', strtotime($search['start_time'].' 00:00:00'));
        if(isset($search['end_time']) && !empty($search['end_time']))                           $queryBuilder->andWhere($queryBuilder->expr()->lte('o.balanceChangeTime', ':endTime'))->setParameter('endTime', strtotime($search['end_time'].' 23:59:59'));
        if(isset($search['balance_change_info']) && !empty($search['balance_change_info']))     $queryBuilder->andWhere($queryBuilder->expr()->like('o.balanceChangeInfo', "'%".$search['balance_change_info']."%'"));

        if(isset($search['search_name']) && !empty($search['search_name']))
            $queryBuilder->andWhere(
                $queryBuilder->expr()->orX()
                    ->add(
                        $queryBuilder->expr()->andX()->add($queryBuilder->expr()->eq('o.userName', ':searchName'))->add($queryBuilder->expr()->eq('o.adminId', 0)))
                    ->add(
                        $queryBuilder->expr()->andX()->add($queryBuilder->expr()->eq('o.adminName', ':searchName'))->add($queryBuilder->expr()->neq('o.adminId', 0)))
            )->setParameter('searchName', $search['search_name']);

        return $queryBuilder;
    }

    /**
     * 前台对检索信息进行处理
     * @param $search
     * @param QueryBuilder $queryBuilder
     * @return QueryBuilder
     */
    public static function shopQuerySearchData($search, QueryBuilder $queryBuilder)
    {
        return $queryBuilder;
    }
}