<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Repository\QuerySearch;

use Doctrine\ORM\QueryBuilder;

class IntegralLogSearch
{
    /**
     * 对检索信息进行处理
     * @param $search
     * @param QueryBuilder $queryBuilder
     * @return QueryBuilder
     */
    public static function querySearchData($search, QueryBuilder $queryBuilder)
    {
        if(isset($search['user_name']) && !empty($search['user_name']))                 $queryBuilder->andWhere($queryBuilder->expr()->eq('o.userName', ':userName'))->setParameter('userName', $search['user_name']);
        if(isset($search['change_integral_num']) && $search['change_integral_num'] != 0) $queryBuilder->andWhere($queryBuilder->expr()->eq('o.changeIntegralNum', $search['change_integral_num']));
        if(isset($search['integral_type_id']) && $search['integral_type_id'] > 0)       $queryBuilder->andWhere($queryBuilder->expr()->eq('o.integralTypeId', $search['integral_type_id']));
        if(isset($search['integral_log_info']) && !empty($search['integral_log_info'])) $queryBuilder->andWhere($queryBuilder->expr()->like('o.integralLogInfo', "'%".$search['integral_log_info']."%'"));
        if(isset($search['start_time']) && !empty($search['start_time']))               $queryBuilder->andWhere($queryBuilder->expr()->gte('o.integralLogTime', ':startTime'))->setParameter('startTime', strtotime($search['start_time'].' 00:00:00'));
        if(isset($search['end_time']) && !empty($search['end_time']))                   $queryBuilder->andWhere($queryBuilder->expr()->lte('o.integralLogTime', ':endTime'))->setParameter('endTime', strtotime($search['end_time'].' 23:59:59'));
        if(isset($search['oper_name']) && !empty($search['oper_name']))
            $queryBuilder->andWhere(
                $queryBuilder->expr()->orX()
                    ->add(
                        $queryBuilder->expr()->andX()->add($queryBuilder->expr()->eq('o.userName', ':searchName'))->add($queryBuilder->expr()->eq('o.adminId', 0)))
                    ->add(
                        $queryBuilder->expr()->andX()->add($queryBuilder->expr()->eq('o.adminName', ':searchName'))->add($queryBuilder->expr()->neq('o.adminId', 0)))
            )->setParameter('searchName', $search['oper_name']);

        return $queryBuilder;
    }

    /**
     * 前台对检索信息处理
     * @param $search
     * @param QueryBuilder $queryBuilder
     * @return QueryBuilder
     */
    public static function shopQuerySearchData($search, QueryBuilder $queryBuilder)
    {
        if(isset($search['integral_type_id']) && $search['integral_type_id'] > 0)       $queryBuilder->andWhere($queryBuilder->expr()->eq('o.integralTypeId', $search['integral_type_id']));

        return $queryBuilder;
    }
}