<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Repository\QuerySearch;

use Doctrine\ORM\QueryBuilder;

class UserRechargeSearch
{
    /**
     * 充值检索
     * @param $search
     * @param QueryBuilder $queryBuilder
     * @return QueryBuilder
     */
    public static function querySearchData($search, QueryBuilder $queryBuilder)
    {
        if(isset($search['add_start_time']) && !empty($search['add_start_time']))               $queryBuilder->andWhere($queryBuilder->expr()->gte('r.addRechargeTime', ':addStartTime'))->setParameter('addStartTime', strtotime($search['add_start_time'].' 00:00:00'));
        if(isset($search['add_end_time']) && !empty($search['add_end_time']))                   $queryBuilder->andWhere($queryBuilder->expr()->lte('r.addRechargeTime', ':addEndTime'))->setParameter('addEndTime', strtotime($search['add_end_time'].' 23:59:59'));
        if(isset($search['pay_state']) && $search['pay_state'] > 0)                             $queryBuilder->andWhere($queryBuilder->expr()->eq('r.payState', $search['pay_state']));
        if(isset($search['user_name']) && !empty($search['user_name']))                         $queryBuilder->andWhere($queryBuilder->expr()->eq('r.userName', ':userName'))->setParameter('userName', $search['user_name']);
        if(isset($search['pay_name']) && !empty($search['pay_name']))                           $queryBuilder->andWhere($queryBuilder->expr()->eq('r.payName', ':payName'))->setParameter('payName', $search['pay_name']);
        if(isset($search['recharge_num']) && $search['recharge_num'] > 0)                       $queryBuilder->andWhere($queryBuilder->expr()->eq('r.rechargeNum', $search['recharge_num']));
        if(isset($search['base_recharge_num']) && $search['base_recharge_num'] > 0)             $queryBuilder->andWhere($queryBuilder->expr()->eq('r.baseRechargeNum', $search['base_recharge_num']));
        if(isset($search['finish_start_time']) && !empty($search['finish_start_time']))         $queryBuilder->andWhere($queryBuilder->expr()->gte('r.finishRechargeTime', ':finishStartTime'))->setParameter('finishStartTime', strtotime($search['finish_start_time'].' 00:00:00'));
        if(isset($search['finish_end_time']) && !empty($search['finish_end_time']))             $queryBuilder->andWhere($queryBuilder->expr()->lte('r.finishRechargeTime', ':finishEndTime'))->setParameter('finishEndTime', strtotime($search['finish_end_time'].' 23:59:59'));

        return $queryBuilder;
    }
}