<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Repository\QuerySearch;

use Doctrine\ORM\QueryBuilder;

class UserSearch
{
    /**
     * 对检索信息进行处理
     * @param $search
     * @param QueryBuilder $queryBuilder
     * @return QueryBuilder
     */
    public static function querySearchData($search, QueryBuilder $queryBuilder)
    {
        if(isset($search['start_id']) && $search['start_id'] > 0)               $queryBuilder->andWhere($queryBuilder->expr()->gte('u.userId', $search['start_id']));
        if(isset($search['end_id']) && $search['end_id'] > 0)                   $queryBuilder->andWhere($queryBuilder->expr()->lte('u.userId', $search['end_id']));
        if(isset($search['user_name']) && !empty($search['user_name']))         $queryBuilder->andWhere($queryBuilder->expr()->like('u.userName', "'%".$search['user_name']."%'"));
        if(isset($search['user_email']) && !empty($search['user_email']))       $queryBuilder->andWhere($queryBuilder->expr()->eq('u.userEmail', ':userEmail'))->setParameter('userEmail', $search['user_email']);
        if(isset($search['user_phone']) && !empty($search['user_phone']))       $queryBuilder->andWhere($queryBuilder->expr()->eq('u.userPhone', ':userPhone'))->setParameter('userPhone', $search['user_phone']);
        if(isset($search['user_group_id']) && !empty($search['user_group_id'])) $queryBuilder->andWhere($queryBuilder->expr()->eq('u.userGroupId', ':userGroupId'))->setParameter('userGroupId', intval($search['user_group_id']));
        if(isset($search['user_money']) && !empty($search['user_money']))       $queryBuilder->andWhere($queryBuilder->expr()->like('u.userMoney', "'%".$search['user_money']."%'"));
        if(isset($search['user_status']) && !empty($search['user_status']))     $queryBuilder->andWhere($queryBuilder->expr()->eq('u.userStatus', ':userStatus'))->setParameter('userStatus', $search['user_status']);
        if(isset($search['start_time']) && !empty($search['start_time']))       $queryBuilder->andWhere($queryBuilder->expr()->gte('u.userAddTime', ':startTime'))->setParameter('startTime', strtotime($search['start_time'].' 00:00:00'));
        if(isset($search['end_time']) && !empty($search['end_time']))           $queryBuilder->andWhere($queryBuilder->expr()->lte('u.userAddTime', ':endTime'))->setParameter('endTime', strtotime($search['end_time'].' 23:59:59'));

        return $queryBuilder;
    }
}