<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Repository\QuerySearch;

use Doctrine\ORM\QueryBuilder;

class WithdrawSearch
{
    /**
     * 对检索信息进行处理
     * @param $search
     * @param QueryBuilder $queryBuilder
     * @return QueryBuilder
     */
    public static function querySearchData($search, QueryBuilder $queryBuilder)
    {
        if(isset($search['add_start_time']) && !empty($search['add_start_time']))               $queryBuilder->andWhere($queryBuilder->expr()->gte('w.addWithdrawTime', ':addStartTime'))->setParameter('addStartTime', strtotime($search['add_start_time'].' 00:00:00'));
        if(isset($search['add_end_time']) && !empty($search['add_end_time']))                   $queryBuilder->andWhere($queryBuilder->expr()->lte('w.addWithdrawTime', ':addEndTime'))->setParameter('addEndTime', strtotime($search['add_end_time'].' 23:59:59'));
        if(isset($search['withdraw_state']) && $search['withdraw_state'] > 0)                   $queryBuilder->andWhere($queryBuilder->expr()->eq('w.withdrawState', $search['withdraw_state']));
        if(isset($search['user_name']) && !empty($search['user_name']))                         $queryBuilder->andWhere($queryBuilder->expr()->eq('w.userName', ':userName'))->setParameter('userName', $search['user_name']);
        if(isset($search['admin_name']) && !empty($search['admin_name']))                       $queryBuilder->andWhere($queryBuilder->expr()->eq('w.adminName', ':adminName'))->setParameter('adminName', $search['admin_name']);
        if(isset($search['withdraw_num']) && $search['withdraw_num'] > 0)                       $queryBuilder->andWhere($queryBuilder->expr()->eq('w.moneyChangeNum', $search['withdraw_num']));
        if(isset($search['finish_start_time']) && !empty($search['finish_start_time']))         $queryBuilder->andWhere($queryBuilder->expr()->gte('w.withdrawFinishTime', ':finishStartTime'))->setParameter('finishStartTime', strtotime($search['finish_start_time'].' 00:00:00'));
        if(isset($search['finish_end_time']) && !empty($search['finish_end_time']))             $queryBuilder->andWhere($queryBuilder->expr()->lte('w.withdrawFinishTime', ':finishEndTime'))->setParameter('finishEndTime', strtotime($search['finish_end_time'].' 23:59:59'));
        if(isset($search['withdraw_info']) && !empty($search['withdraw_info']))                 $queryBuilder->andWhere($queryBuilder->expr()->like('w.withdrawInfo', "'%".$search['withdraw_info']."%'"));

        return $queryBuilder;
    }
}