<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Repository;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Query\Expr\Join;
use Goods\Entity\Goods;
use Goods\Entity\GoodsImage;
use User\Entity\UserGoodsFavorites;

class UserGoodsFavoritesRepository extends EntityRepository
{
    /**
     * 客户商品收藏信息
     * @param $userId
     * @return int|mixed|string
     */
    public function findGoodsFavorites($userId)
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('f', 'g.goodsName', 'i.goodsThumbnailImage')
            ->from(UserGoodsFavorites::class, 'f')
            ->innerJoin(Goods::class, 'g', Join::WITH, 'f.goodsId = g.goodsId')
            ->leftJoin(GoodsImage::class, 'i', Join::WITH, 'g.goodsImageId=i.goodsImageId')
            ->where('f.userId = :userId')->setParameter('userId', $userId)
            ->orderBy('f.goodsFavoritesId', 'DESC');

        return $query->getQuery()->getResult();
    }

    /*=======================================下面为前台使用=======================================*/
    /**
     * 商品收藏列表
     * @param $userId
     * @return \Doctrine\ORM\Query
     */
    public function shopGoodsFavoritesList($userId)
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('f', 'g.goodsName', 'i.goodsThumbnailImage')
            ->from(UserGoodsFavorites::class, 'f')
            ->innerJoin(Goods::class, 'g', Join::WITH, 'f.goodsId = g.goodsId')
            ->leftJoin(GoodsImage::class, 'i', Join::WITH, 'g.goodsImageId=i.goodsImageId')
            ->where('f.userId = :userId')->setParameter('userId', $userId)
            ->orderBy('f.goodsFavoritesId', 'DESC');

        return $query->getQuery();
    }
}