<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Repository;

use Doctrine\ORM\EntityRepository;
use User\Entity\UserOtherLogin;
use function Doctrine\ORM\QueryBuilder;

class UserOtherLoginRepository extends EntityRepository
{
    /*==============================================下面为前台调用==============================================*/
    /**
     * 获取第三方登录信息是否已经存在
     * @param $openId
     * @param $unionId
     * @param $loginType
     * @return int|mixed|string|null
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function shopFindUserOtherLogin($openId, $unionId, $loginType)
    {
        if (empty($openId) && empty($unionId)) return null;

        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('o')
            ->from(UserOtherLogin::class, 'o')
            ->where('o.loginType = :loginType')->setParameter('loginType', $loginType);

        if ($openId && $unionId) {
            $query->andWhere(
                $query->expr()->orX()
                    ->add($query->expr()->eq('o.openId', ':openId'))
                    ->add($query->expr()->eq('o.unionId', ':unionId'))
            )->setParameter('openId', $openId)->setParameter('unionId', $unionId);
        } else $query->andWhere('o.openId = :openId')->setParameter('openId', $openId);

        return $query->getQuery()->getOneOrNullResult();
    }
}