<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Repository;

use Doctrine\ORM\EntityRepository;
use User\Entity\UserRecharge;
use User\Repository\QuerySearch\UserRechargeSearch;

class UserRechargeRepository extends EntityRepository
{
    /**
     * 充值列表
     * @param array $search
     * @return \Doctrine\ORM\Query
     */
    public function findUserRechargeList(array $search = [])
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('r')
            ->from(UserRecharge::class, 'r')
            ->orderBy('r.payState', 'DESC')
            ->addOrderBy('r.rechargeId', 'DESC');

        $query = UserRechargeSearch::querySearchData($search, $query);

        return $query->getQuery();
    }
}