<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Repository;

use Doctrine\ORM\EntityRepository;
use User\Entity\UserWithdraw;
use User\Repository\QuerySearch\WithdrawSearch;

class UserWithdrawRepository extends EntityRepository
{
    /**
     * 余额提现
     * @param array $search
     * @return \Doctrine\ORM\Query
     */
    public function findAllWithdrawList(array $search = [])
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('w')
            ->from(UserWithdraw::class, 'w')
            ->orderBy('w.withdrawId', 'DESC');

        $query = WithdrawSearch::querySearchData($search, $query);

        return $query->getQuery();
    }

    /*==============================================下面为前台调用==============================================*/
    /**
     * 会员余额提现列表
     * @param $userId
     * @return \Doctrine\ORM\Query
     */
    public function findUserWithdrawList($userId)
    {
        $query = $this->getEntityManager()->createQueryBuilder();
        $query->select('w')
            ->from(UserWithdraw::class, 'w')
            ->where('w.userId = :userId')->setParameter('userId', $userId)
            ->orderBy('w.withdrawId', 'DESC');

        return $query->getQuery();
    }
}