<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Service\Common\AppLogin;

use Admin\Data\Common;
use Laminas\Json\Json;
use Laminas\Session\Container;

class WechatScanLogin
{
    const GET_AUTH_CODE_URL     = "https://open.weixin.qq.com/connect/qrconnect";
    const GET_ACCESS_TOKEN_URL  = "https://api.weixin.qq.com/sns/oauth2/access_token";
    const GET_USERINFO_URL      = "https://api.weixin.qq.com/sns/userinfo";

    public $redirectUri;

    private $customerConfig     = [];
    private $loginSession;

    public function __construct()
    {
        $this->customerConfig   = Common::readConfigFile('customer');
        $this->loginSession     = new Container('wechatScanSession');
    }

    /**
     * 微信的第一次请求操作
     */
    public function toLogin()
    {
        $loginKey = [
            'response_type' => 'code',
            'appid'         => $this->customerConfig['weixin_web_app_id'],
            'redirect_uri'  => $this->redirectUri,
            'state'         => md5(uniqid(rand(), TRUE)),
            'scope'         => 'snsapi_login'
        ];

        $this->loginSession->offsetSet('wechatScanState', $loginKey['state']);

        header("Location: {$this->combineUrl(self::GET_AUTH_CODE_URL, $loginKey)}");
        exit();
    }

    /**
     * 跳转返回处理
     */
    public function loginCallBock()
    {
        if ($this->loginSession->offsetGet('wechatScanState') != $_GET['state']) {
            exit('<h2>The state does not match. You may be a victim of CSRF.</h2>');
        }

        $loginKey = [
            'grant_type'    => 'authorization_code',
            'appid'         => $this->customerConfig['weixin_web_app_id'],
            'secret'        => $this->customerConfig['weixin_web_app_key'],
            'code'          => $_GET['code']
        ];

        $response = Common::httpGet($this->combineUrl(self::GET_ACCESS_TOKEN_URL, $loginKey));
        if (strpos($response, "access_token") !== false) {
            $result = Json::decode($response);
            if (isset($result->errcode)) {
                exit('error:' . $result->errcode . 'error:' . $result->errmsg);
            }

            $this->loginSession->offsetSet('wechatScanAccessToken', $result->access_token);
            $this->loginSession->offsetSet('wechatScanOpenId',  $result->openid);
            $this->loginSession->offsetSet('wechatScanUnionId', $result->unionid);
        }
    }

    /**
     * openId
     * @return mixed|null
     */
    public function openId()
    {
        return $this->loginSession->offsetGet('wechatScanOpenId');
    }

    /**
     * unionId
     * @return mixed|null
     */
    public function unionId()
    {
        return $this->loginSession->offsetGet('wechatScanUnionId');
    }

    /**
     * 账户信息
     * @return mixed
     */
    public function loginUserInfo()
    {
        $infoKey = [
            'access_token'       => $this->loginSession->offsetGet('wechatScanAccessToken'),
            'openid'             => $this->loginSession->offsetGet('wechatScanOpenId')
        ];

        $responseArray = Json::decode(Common::httpGet($this->combineUrl(self::GET_USERINFO_URL, $infoKey)), Json::TYPE_ARRAY);

        //检查返回ret判断api是否成功调用
        if(isset($responseArray['openid']) and !empty($responseArray['openid'])){
            return $responseArray;
        }else{
            exit('error:' . $responseArray['errcode'] . 'error:' . $responseArray['errmsg']);
        }
    }

    /**
     * 清除使用过的session
     */
    public function clearOtherLoginSession()
    {
        $this->loginSession->getManager()->getStorage()->clear($this->loginSession->getName());
    }

    /**
     * 拼接Url
     * @param $baseUrl
     * @param $keyArray
     * @return string
     */
    private function combineUrl($baseUrl, $keyArray)
    {
        return $baseUrl . '?' . Common::toUrlParams($keyArray);
    }
}