<?php
/**
 * DBShop 电子商务系统
 *
 * ==========================================================================
 * @link      https://www.dbshop.net/
 * @copyright 北京珑大钜商科技有限公司，并保留所有权利。
 * @license   https://www.dbshop.net/license.html License
 * ==========================================================================
 *
 * @author    静静的风 <baron@loongdom.cn>
 *
 */

namespace User\Service\Common;

use Admin\Data\Common;

class IntegralCalculation
{
    /**
     * 会员注册获取积分
     * @return int[]
     */
    public static function userRegisterIntegral()
    {
        $registerRule = Common::configValue('userRegister', 'integralRule');

        //integralType1 消费积分，integralType2 等级积分
        $integralArray= ['integralType1' => 0, 'integralType2' => 0];

        if(!empty($registerRule)) foreach ($registerRule as $ruleValue) {
            if (!Common::checkTime($ruleValue['integralRuleStartTime'], $ruleValue['integralRuleEndTime'])) continue;

            if($ruleValue['integralTypeId'] == 1 && $ruleValue['integralNum'] > 0) {//消费积分
                if($integralArray['integralType1'] > 0) continue;
                else $integralArray['integralType1'] = $ruleValue['integralNum'];
            }
            if($ruleValue['integralTypeId'] == 2 && $ruleValue['integralNum'] > 0) {//等级积分
                if($integralArray['integralType2'] > 0) continue;
                else $integralArray['integralType2'] = $ruleValue['integralNum'];
            }
        }

        return $integralArray;
    }

    /**
     * 购物车进行获取积分数量的计算
     * @param $goodsCart
     * @param array $data
     * @return int[]
     */
    public static function buyGoodsCartIntegral($goodsCart, array $data)
    {
        $buyGoodsRule = Common::configValue('goodsBuy', 'integralRule');

        //integralType1 消费积分，integralType2 等级积分
        $integralType1Cost = [];
        $integralType2Cost = [];
        if(!empty($buyGoodsRule)) foreach ($buyGoodsRule as $ruleKey => $ruleValue) {
            if (!Common::checkTime($ruleValue['integralRuleStartTime'], $ruleValue['integralRuleEndTime'])) continue;
            if (!Common::checkUser($data['userGroupId'], $ruleValue['integralRuleUserType'], $ruleValue['integralRuleUserBody'])) continue;

            $costTotal = self::cartCostTotal($goodsCart, $ruleValue, $data['discountCost']);

            if($costTotal >= $ruleValue['integralRuleBody']['shoppingAmount']) {
                if($ruleValue['integralRuleBody']['shoppingType'] == 1) {
                    $integralNum = (int) $ruleValue['integralNum'];
                } else {
                    $n = floor($costTotal/$ruleValue['integralRuleBody']['shoppingAmount']);
                    $integralNum = (int) ($ruleValue['integralNum'] * $n);
                }

                if($ruleValue['integralTypeId'] == 1) $integralType1Cost[$ruleKey] = $integralNum;
                else $integralType2Cost[$ruleKey] = $integralNum;
            }
        }

        return [
            'integralType1Num' => empty($integralType1Cost) ? 0 : max($integralType1Cost),
            'integralType2Num' => empty($integralType2Cost) ? 0 : max($integralType2Cost)
        ];
    }

    /**
     * 购物车过滤符合条件的商品，并计算总金额
     * @param $goodsCart
     * @param $rule
     * @param $discountCost
     * @return int|mixed
     */
    private static function cartCostTotal($goodsCart, $rule, $discountCost)
    {
        $costTotal = 0;
        foreach ($goodsCart as $goodsValue) {
            if (Common::checkGoods($goodsValue['classId'], $rule['integralRuleGoodsType'], $rule['integralRuleGoodsBody'], $goodsValue['brandId'])) {
                $costTotal = $costTotal + $goodsValue['goodsAmount'];
            }
        }

        if ($costTotal > 0 && $discountCost > 0) $costTotal = $costTotal - $discountCost;

        return $costTotal;
    }
}